/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.FileContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnProgressCanceller;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.status.SvnDiffEditor;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNReporter;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class CompareWithBranchAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.actions.CompareWithBranchAction");

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        assert (project != null);
        final VirtualFile virtualFile = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        SelectBranchPopup.show(project, virtualFile, new SelectBranchPopup.BranchSelectedCallback(){

            @Override
            public void branchSelected(Project project, SvnBranchConfigurationNew configuration, String url, long revision) {
                new CompareWithBranchOperation(project, virtualFile, configuration).compareWithBranch(url, revision);
            }
        }, SvnBundle.message("compare.with.branch.popup.title", new Object[0]));
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        e.getPresentation().setEnabled(CompareWithBranchAction.isEnabled(project, virtualFile));
    }

    private static boolean isEnabled(Project project, VirtualFile virtualFile) {
        if (project == null || virtualFile == null) {
            return false;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(virtualFile);
        return fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.ADDED;
    }

    private class CompareWithBranchOperation {
        private final Project myProject;
        private final VirtualFile myVirtualFile;
        private final SvnBranchConfigurationNew myConfiguration;
        final StringBuilder titleBuilder = new StringBuilder();

        public CompareWithBranchOperation(Project project, VirtualFile virtualFile, SvnBranchConfigurationNew config) {
            this.myProject = project;
            this.myVirtualFile = virtualFile;
            this.myConfiguration = config;
        }

        public void compareWithBranch(String baseUrl, long revision) {
            if (this.myVirtualFile.isDirectory()) {
                this.compareDirectoryWithBranch(baseUrl, revision);
            } else {
                this.compareFileWithBranch(baseUrl, revision);
            }
        }

        public void compareDirectoryWithBranch(final String baseUrl, long revision) {
            final ArrayList changes = new ArrayList();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SvnVcs vcs = SvnVcs.getInstance(CompareWithBranchOperation.this.myProject);
                        SVNURL url = CompareWithBranchOperation.this.getURLInBranch(vcs, baseUrl);
                        if (url == null) {
                            return;
                        }
                        CompareWithBranchOperation.this.titleBuilder.append(SvnBundle.message("repository.browser.compare.title", url.toString(), FileUtil.toSystemDependentName((String)CompareWithBranchOperation.this.myVirtualFile.getPresentableUrl())));
                        SVNWCAccess wcAccess = vcs.createWCAccess();
                        SVNRepository repository = null;
                        SVNRepository repository2 = null;
                        try {
                            SVNErrorMessage err;
                            SVNAdminAreaInfo info = wcAccess.openAnchor(new File(CompareWithBranchOperation.this.myVirtualFile.getPath()), false, -1);
                            File anchorPath = info.getAnchor().getRoot();
                            String target = "".equals(info.getTargetName()) ? null : info.getTargetName();
                            SVNEntry anchorEntry = info.getAnchor().getEntry("", false);
                            if (anchorEntry == null) {
                                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_NOT_FOUND, (String)"''{0}'' is not under version control", (Object)anchorPath);
                                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.WC);
                            } else if (anchorEntry.getURL() == null) {
                                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ENTRY_MISSING_URL, (String)"''{0}'' has no URL", (Object)anchorPath);
                                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.WC);
                            }
                            SVNURL anchorURL = anchorEntry.getSVNURL();
                            repository = vcs.createRepository(anchorURL.toString());
                            SVNReporter reporter = new SVNReporter(info, info.getAnchor().getFile(info.getTargetName()), false, true, SVNDepth.INFINITY, false, false, true, SVNDebugLog.getDefaultLog());
                            long rev = repository.getLatestRevision();
                            repository2 = vcs.createRepository(target == null ? url.toString() : url.removePathTail().toString());
                            SvnDiffEditor diffEditor = new SvnDiffEditor(target == null ? CompareWithBranchOperation.this.myVirtualFile : CompareWithBranchOperation.this.myVirtualFile.getParent(), repository2, rev, true);
                            repository.diff(url, rev, rev, target, true, true, false, (ISVNReporterBaton)reporter, SVNCancellableEditor.newInstance((ISVNEditor)diffEditor, (ISVNCanceller)new SvnProgressCanceller(), null));
                            changes.addAll(diffEditor.getChangesMap().values());
                        }
                        finally {
                            wcAccess.close();
                            if (repository != null) {
                                repository.closeSession();
                            }
                            if (repository2 != null) {
                                repository2.closeSession();
                            }
                        }
                    }
                    catch (SVNCancelException ex) {
                        changes.clear();
                    }
                    catch (SVNException ex) {
                        CompareWithBranchOperation.this.reportException(ex, baseUrl);
                    }
                }
            }, SvnBundle.message("progress.computing.difference", new Object[0]), true, this.myProject);
            if (!changes.isEmpty()) {
                AbstractVcsHelper.getInstance((Project)this.myProject).showWhatDiffersBrowser(null, changes, this.titleBuilder.toString());
            }
        }

        public void compareFileWithBranch(final String baseUrl, long revision) {
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();
            final StringBuilder remoteTitleBuilder = new StringBuilder();
            final Ref success = new Ref();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    try {
                        SvnVcs vcs;
                        SVNURL svnurl;
                        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                        if (indicator != null) {
                            indicator.setIndeterminate(true);
                        }
                        if ((svnurl = CompareWithBranchOperation.this.getURLInBranch(vcs = SvnVcs.getInstance(CompareWithBranchOperation.this.myProject), baseUrl)) == null) {
                            return;
                        }
                        remoteTitleBuilder.append(svnurl.toString());
                        SVNWCClient client = vcs.createWCClient();
                        client.doGetFileContents(svnurl, SVNRevision.UNDEFINED, SVNRevision.HEAD, true, (OutputStream)baos);
                        success.set((Object)true);
                    }
                    catch (SVNException ex) {
                        CompareWithBranchOperation.this.reportException(ex, baseUrl);
                    }
                }
            }, SvnBundle.message("compare.with.branch.progress.loading.content", new Object[0]), true, this.myProject);
            if (success.isNull()) {
                return;
            }
            ByteBuffer contents = ByteBuffer.wrap(baos.toByteArray());
            SimpleDiffRequest req = new SimpleDiffRequest(this.myProject, SvnBundle.message("compare.with.branch.diff.title", new Object[0]));
            req.setContents((DiffContent)new SimpleContent(this.myVirtualFile.getCharset().decode(contents).toString()), (DiffContent)new FileContent(this.myProject, this.myVirtualFile));
            req.setContentTitles(remoteTitleBuilder.toString(), this.myVirtualFile.getPresentableUrl());
            DiffManager.getInstance().getDiffTool().show((DiffRequest)req);
        }

        @Nullable
        private SVNURL getURLInBranch(SvnVcs vcs, String baseUrl) throws SVNException {
            File file;
            SvnFileUrlMapping urlMapping = vcs.getSvnFileUrlMapping();
            SVNURL fileUrl = urlMapping.getUrlForFile(file = new File(this.myVirtualFile.getPath()));
            if (fileUrl == null) {
                return null;
            }
            String fileUrlString = fileUrl.toString();
            RootUrlInfo rootMixed = urlMapping.getWcRootForUrl(fileUrlString);
            if (rootMixed == null) {
                return null;
            }
            SVNURL thisBranchForUrl = SvnUtil.getBranchForUrl(vcs, rootMixed.getVirtualFile(), fileUrlString);
            if (thisBranchForUrl == null) {
                return null;
            }
            String relativePath = SVNPathUtil.getRelativePath((String)thisBranchForUrl.toString(), (String)fileUrlString);
            return SVNURL.parseURIEncoded((String)SVNPathUtil.append((String)baseUrl, (String)relativePath));
        }

        private void reportException(final SVNException ex, String baseUrl) {
            SVNErrorCode errorCode = ex.getErrorMessage().getErrorCode();
            if (errorCode.equals((Object)SVNErrorCode.RA_ILLEGAL_URL) || errorCode.equals((Object)SVNErrorCode.CLIENT_UNRELATED_RESOURCES) || errorCode.equals((Object)SVNErrorCode.RA_DAV_PATH_NOT_FOUND) || errorCode.equals((Object)SVNErrorCode.FS_NOT_FOUND)) {
                this.reportNotFound(baseUrl);
            } else {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showMessageDialog((Project)CompareWithBranchOperation.this.myProject, (String)ex.getMessage(), (String)SvnBundle.message("compare.with.branch.error.title", new Object[0]), (Icon)Messages.getErrorIcon());
                    }
                });
                LOG.info((Throwable)ex);
            }
        }

        private void reportNotFound(final String baseUrl) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showMessageDialog((Project)CompareWithBranchOperation.this.myProject, (String)SvnBundle.message("compare.with.branch.location.error", CompareWithBranchOperation.this.myVirtualFile.getPresentableUrl(), baseUrl), (String)SvnBundle.message("compare.with.branch.error.title", new Object[0]), (Icon)Messages.getErrorIcon());
                }
            });
        }
    }
}

