/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.idea.svn.IdeaSVNConfigFile;
import org.jetbrains.idea.svn.SvnServerFileManager;
import org.jetbrains.idea.svn.config.DefaultProxyGroup;
import org.jetbrains.idea.svn.config.ProxyGroup;

public class SvnServerFileManagerImpl
implements SvnServerFileManager {
    private final DefaultProxyGroup myDefaultGroup;
    private final Map<String, ProxyGroup> myGroups;
    private final IdeaSVNConfigFile myFile;

    public SvnServerFileManagerImpl(IdeaSVNConfigFile file) {
        this.myFile = file;
        this.myFile.updateGroups();
        this.myGroups = new HashMap<String, ProxyGroup>();
        this.myGroups.putAll(file.getAllGroups());
        this.myDefaultGroup = file.getDefaultGroup();
    }

    @Override
    public DefaultProxyGroup getDefaultGroup() {
        return (DefaultProxyGroup)this.myDefaultGroup.copy();
    }

    @Override
    public Map<String, ProxyGroup> getGroups() {
        HashMap<String, ProxyGroup> result = new HashMap<String, ProxyGroup>(this.myGroups);
        for (Map.Entry<String, ProxyGroup> entry : this.myGroups.entrySet()) {
            result.put(entry.getKey(), entry.getValue().copy());
        }
        return result;
    }

    @Override
    public void updateUserServerFile(Collection<ProxyGroup> newUserGroups) {
        Map<String, ProxyGroup> oldGroups = this.getGroups();
        for (ProxyGroup proxyGroup : newUserGroups) {
            if (proxyGroup.isDefault()) {
                this.processGroup(proxyGroup, this.getDefaultGroup(), false);
                continue;
            }
            this.findAndProcessGroup(proxyGroup, oldGroups);
        }
        for (String groupName : oldGroups.keySet()) {
            this.myFile.deleteGroup(groupName);
        }
        this.myFile.save();
    }

    private void processGroup(ProxyGroup newGroup, ProxyGroup oldGroup, boolean groupWasAdded) {
        String newGroupName = newGroup.getName();
        if (groupWasAdded) {
            this.myFile.addGroup(newGroupName, newGroup.getPatterns(), newGroup.getProperties());
        } else {
            Map<String, String> oldProperties = oldGroup.getProperties();
            Map<String, String> newProperties = newGroup.getProperties();
            HashSet<String> deletedProperties = new HashSet<String>();
            for (String oldKey : oldProperties.keySet()) {
                if (newProperties.containsKey(oldKey)) continue;
                deletedProperties.add(oldKey);
            }
            HashMap<String, String> newOrModifiedProperties = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : newProperties.entrySet()) {
                String oldValue = oldProperties.get(entry.getKey());
                if (oldValue != null && oldValue.equals(entry.getValue())) continue;
                newOrModifiedProperties.put(entry.getKey(), entry.getValue());
            }
            this.myFile.modifyGroup(newGroupName, newGroup.getPatterns(), deletedProperties, newOrModifiedProperties, newGroup.isDefault());
        }
    }

    private void findAndProcessGroup(ProxyGroup newGroup, Map<String, ProxyGroup> oldGroups) {
        boolean groupWasAdded;
        String newGroupName = newGroup.getName();
        ProxyGroup oldGroup = oldGroups.get(newGroupName);
        boolean bl = groupWasAdded = oldGroup == null && !newGroup.isDefault();
        if (!groupWasAdded) {
            oldGroups.remove(newGroupName);
        }
        this.processGroup(newGroup, oldGroup, groupWasAdded);
    }
}

