/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.impl.ExcludedFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.idea.svn.StatusWalkerPartner;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNStatusClient;

public class StatusWalkerPartnerImpl
implements StatusWalkerPartner {
    private final SvnVcs myVcs;
    private final ChangeListManager myClManager;
    private final ExcludedFileIndex myExcludedFileIndex;
    private final ProgressIndicator myIndicator;
    private ISVNStatusFileProvider myFileProvider;

    public StatusWalkerPartnerImpl(SvnVcs vcs, ProgressIndicator pi) {
        this.myVcs = vcs;
        this.myClManager = ChangeListManager.getInstance((Project)this.myVcs.getProject());
        this.myExcludedFileIndex = ExcludedFileIndex.getInstance((Project)this.myVcs.getProject());
        this.myIndicator = pi;
    }

    public void setFileProvider(ISVNStatusFileProvider fileProvider) {
        this.myFileProvider = fileProvider;
    }

    @Override
    public SVNStatusClient createStatusClient() {
        SVNStatusClient result = this.myVcs.createStatusClient();
        result.setFilesProvider(this.myFileProvider);
        result.setEventHandler(new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
            }

            public void checkCancelled() throws SVNCancelException {
                if (StatusWalkerPartnerImpl.this.myIndicator != null) {
                    StatusWalkerPartnerImpl.this.myIndicator.checkCanceled();
                }
            }
        });
        return result;
    }

    @Override
    public void checkCanceled() {
        if (this.myIndicator != null) {
            this.myIndicator.checkCanceled();
        }
    }

    @Override
    public boolean isExcluded(VirtualFile vFile) {
        return this.myExcludedFileIndex.isExcludedFile(vFile);
    }

    @Override
    public boolean isIgnoredIdeaLevel(VirtualFile vFile) {
        return this.myClManager.isIgnoredFile(vFile);
    }
}

