/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.IconLoader;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public final class ConflictState
extends Enum<ConflictState> {
    public static final /* enum */ ConflictState none = new ConflictState(false, false, false, null);
    public static final /* enum */ ConflictState tree = new ConflictState(true, false, false, "/icons/conflictc.png");
    public static final /* enum */ ConflictState text = new ConflictState(false, true, false, "/icons/conflictt.png");
    public static final /* enum */ ConflictState prop = new ConflictState(false, false, true, "/icons/conflictp.png");
    public static final /* enum */ ConflictState tree_text = new ConflictState(true, true, false, "/icons/conflictct.png");
    public static final /* enum */ ConflictState tree_prop = new ConflictState(true, false, true, "/icons/conflictcp.png");
    public static final /* enum */ ConflictState text_prop = new ConflictState(false, true, true, "/icons/conflicttp.png");
    public static final /* enum */ ConflictState all3 = new ConflictState(true, true, true, "/icons/conflictctp.png");
    private final boolean myTree;
    private final boolean myText;
    private final boolean myProperty;
    @Nullable
    private final Icon myIcon;
    private final String myDescription;
    private static final /* synthetic */ ConflictState[] $VALUES;

    public static ConflictState[] values() {
        return (ConflictState[])$VALUES.clone();
    }

    public static ConflictState valueOf(String name) {
        return Enum.valueOf(ConflictState.class, name);
    }

    private ConflictState(boolean tree, boolean text, boolean property, String iconPath) {
        this.myTree = tree;
        this.myText = text;
        this.myProperty = property;
        this.myIcon = iconPath != null ? IconLoader.getIcon((String)iconPath) : null;
        this.myDescription = this.createDescription();
    }

    @Nullable
    private String createDescription() {
        int cnt = 0;
        StringBuilder sb = new StringBuilder();
        cnt = this.checkOne(this.myTree, cnt, sb, "tree");
        cnt = this.checkOne(this.myText, cnt, sb, "text");
        if ((cnt = this.checkOne(this.myProperty, cnt, sb, "property")) == 0) {
            return null;
        }
        return sb.toString();
    }

    private int checkOne(boolean value, int init, StringBuilder sb, String text) {
        if (value) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(text);
            return init + 1;
        }
        return init;
    }

    public boolean isTree() {
        return this.myTree;
    }

    public boolean isText() {
        return this.myText;
    }

    public boolean isProperty() {
        return this.myProperty;
    }

    public boolean isConflict() {
        return this.myProperty || this.myText || this.myTree;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public static ConflictState mergeState(ConflictState leftState, ConflictState rightState) {
        return ConflictState.getInstance(leftState.myTree | rightState.myTree, leftState.myText | rightState.myText, leftState.myProperty | rightState.myProperty);
    }

    public static ConflictState getInstance(boolean tree, boolean text, boolean property) {
        ConflictState[] conflictStates;
        for (ConflictState state : conflictStates = ConflictState.values()) {
            if (state.isTree() != tree || state.isText() != text || state.isProperty() != property) continue;
            return state;
        }
        assert (false);
        return null;
    }

    static {
        $VALUES = new ConflictState[]{none, tree, text, prop, tree_text, tree_prop, text_prop, all3};
    }
}

