/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFilesProvider;
import com.intellij.lang.ant.psi.impl.AntFilesProviderImpl;
import com.intellij.lang.ant.psi.impl.AntPattern;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.PathTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntPathImpl
extends AntFilesProviderImpl {
    public AntPathImpl(AntElement parent, XmlTag sourceElement) {
        super(parent, sourceElement);
    }

    public AntPathImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition, @NonNls String nameElementAttribute) {
        super(parent, sourceElement, definition, nameElementAttribute);
    }

    public AntPathImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition) {
        super(parent, sourceElement, definition);
    }

    @Override
    protected AntPattern getPattern() {
        return null;
    }

    @Override
    @NotNull
    protected List<File> getFiles(AntPattern pattern, Set<AntFilesProvider> processed) {
        AntElement[] children;
        ArrayList<File> files = new ArrayList<File>();
        File baseDir = this.getCanonicalFile(".");
        AntPathImpl.addLocation(baseDir, files, this.computeAttributeValue(this.getSourceElement().getAttributeValue("location")));
        String pathString = this.computeAttributeValue(this.getSourceElement().getAttributeValue("path"));
        if (pathString != null) {
            PathTokenizer tokenizer = new PathTokenizer(pathString);
            while (tokenizer.hasMoreTokens()) {
                AntPathImpl.addLocation(baseDir, files, tokenizer.nextToken());
            }
        }
        for (AntElement child : children = this.getChildren()) {
            if (!(child instanceof AntFilesProvider)) continue;
            files.addAll(((AntFilesProvider)((Object)child)).getFiles(processed));
        }
        ArrayList<File> arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntPathImpl.getFiles must not return null");
        }
        return arrayList;
    }

    private static void addLocation(File baseDir, List<File> files, String locationPath) {
        if (locationPath != null) {
            File file = new File(locationPath);
            if (file.isAbsolute()) {
                files.add(file);
            } else {
                files.add(new File(baseDir, locationPath));
            }
        }
    }
}

