/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.lang.UrlClassLoader;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AntResourcesClassLoader
extends UrlClassLoader {
    private final Set<String> myMisses = new HashSet<String>();

    public AntResourcesClassLoader(List<URL> urls, ClassLoader parentLoader, boolean canLockJars, boolean canUseCache) {
        super(urls, parentLoader, canLockJars, canUseCache);
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.myMisses.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        return super.loadClass(name, resolve);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        ProgressManager.checkCanceled();
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            this.myMisses.add(name);
            throw e;
        }
    }
}

