/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.execution.ExecutionHandler;
import com.intellij.lang.ant.config.impl.BuildTask;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntTarget;
import com.intellij.lang.ant.psi.AntTask;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import org.jetbrains.annotations.Nullable;

public class AntBuildTargetImpl
implements AntBuildTargetBase {
    private final AntBuildModelBase myModel;
    private final VirtualFile myFile;
    private final boolean myIsDefault;
    private final int myHashCode;
    private final String myName;
    private final String myDisplayName;
    private final String myDescription;
    private final Project myProject;
    private final int myTextOffset;

    public AntBuildTargetImpl(AntTarget target, AntBuildModelBase buildModel, VirtualFile sourceFile, boolean isImported, boolean isDefault) {
        this.myModel = buildModel;
        this.myFile = sourceFile;
        this.myIsDefault = isDefault;
        this.myHashCode = target.hashCode();
        this.myName = target.getName();
        this.myDisplayName = isImported ? target.getQualifiedName() : target.getName();
        this.myProject = target.getProject();
        this.myTextOffset = target.getTextOffset();
        String desc = target.getDescription();
        this.myDescription = desc != null && desc.trim().length() > 0 ? desc : null;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AntBuildTargetImpl)) {
            return false;
        }
        AntBuildTargetImpl that = (AntBuildTargetImpl)obj;
        return Comparing.equal((String)this.myName, (String)that.myName) && Comparing.equal((Object)this.myFile, (Object)that.myFile);
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myName;
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Override
    @Nullable
    public String getNotEmptyDescription() {
        return this.myDescription;
    }

    @Override
    public boolean isDefault() {
        return this.myIsDefault;
    }

    @Override
    public VirtualFile getContainingFile() {
        return this.myFile;
    }

    @Override
    public AntBuildModelBase getModel() {
        return this.myModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getActionId() {
        String modelName = this.myModel.getName();
        if (modelName == null || modelName.length() == 0) {
            return null;
        }
        StringBuilder name = StringBuilderSpinAllocator.alloc();
        try {
            name.append(AntConfiguration.getActionIdPrefix(this.myModel.getBuildFile().getProject()));
            name.append("_");
            name.append(modelName);
            name.append('_');
            name.append(this.getName());
            String string = name.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)name);
        }
    }

    @Override
    @Nullable
    public BuildTask findTask(String taskName) {
        AntTarget target;
        AntFile antFile = AntSupport.toAntFile(this.myFile, this.myProject);
        if (antFile != null && (target = antFile.getAntProject().getTarget(this.myName)) != null) {
            for (PsiElement element : target.getChildren()) {
                AntTask task;
                if (!(element instanceof AntTask) || !taskName.equals((task = (AntTask)element).getSourceElement().getName())) continue;
                return new BuildTask(this, task);
            }
        }
        return null;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor() {
        return this.myFile == null ? null : new OpenFileDescriptor(this.myProject, this.myFile, this.myTextOffset);
    }

    @Override
    public void run(DataContext dataContext, AntBuildListener buildListener) {
        String[] stringArray;
        AntBuildModelBase model = this.getModel();
        if (model == null) {
            buildListener.buildFinished(2, 0);
            throw new IllegalStateException("Target '" + this.getName() + "' is invalid: model is null");
        }
        AntBuildFile buildFile = model.getBuildFile();
        if (buildFile == null) {
            buildListener.buildFinished(2, 0);
            throw new IllegalStateException("Target '" + this.getName() + "' is invalid: build file is null");
        }
        if (this.isDefault()) {
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.getName();
        }
        String[] targets = stringArray;
        ExecutionHandler.runBuild((AntBuildFileBase)buildFile, targets, null, dataContext, buildListener);
    }
}

