/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.impl.AntBeforeRunTask;
import com.intellij.lang.ant.config.impl.AntConfigurationImpl;
import com.intellij.lang.ant.config.impl.TargetChooserDialog;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.annotations.Nullable;

public class AntBeforeRunTaskProvider
extends BeforeRunTaskProvider<AntBeforeRunTask> {
    public static final Key<AntBeforeRunTask> ID = Key.create((String)"AntTarget");
    private final Project myProject;

    public AntBeforeRunTaskProvider(Project project) {
        this.myProject = project;
    }

    public Key<AntBeforeRunTask> getId() {
        return ID;
    }

    public String getDescription(RunConfiguration runConfiguration, AntBeforeRunTask task) {
        String targetName = task.getTargetName();
        if (targetName == null && !task.isEnabled()) {
            return AntBundle.message("ant.target.before.run.description.empty", new Object[0]);
        }
        return AntBundle.message("ant.target.before.run.description", targetName != null ? targetName : "<not selected>");
    }

    public boolean hasConfigurationButton() {
        return true;
    }

    public boolean configureTask(RunConfiguration runConfiguration, AntBeforeRunTask task) {
        AntBuildTarget buildTarget = this.findTargetToExecute(task);
        TargetChooserDialog dlg = new TargetChooserDialog(this.myProject, buildTarget);
        dlg.show();
        if (dlg.isOK()) {
            VirtualFile vFile;
            task.setTargetName(null);
            task.setAntFileUrl(null);
            buildTarget = dlg.getSelectedTarget();
            if (buildTarget != null && (vFile = buildTarget.getModel().getBuildFile().getVirtualFile()) != null) {
                task.setAntFileUrl(vFile.getUrl());
                task.setTargetName(buildTarget.getName());
            }
            return true;
        }
        return false;
    }

    public AntBeforeRunTask createTask(RunConfiguration runConfiguration) {
        return new AntBeforeRunTask();
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, AntBeforeRunTask task) {
        AntBuildTarget target = this.findTargetToExecute(task);
        if (target != null) {
            return AntConfigurationImpl.executeTargetSynchronously(context, target);
        }
        return true;
    }

    @Nullable
    private AntBuildTarget findTargetToExecute(AntBeforeRunTask task) {
        String fileUrl = task.getAntFileUrl();
        String targetName = task.getTargetName();
        if (fileUrl == null || targetName == null) {
            return null;
        }
        VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
        if (vFile == null) {
            return null;
        }
        AntConfigurationImpl antConfiguration = (AntConfigurationImpl)AntConfiguration.getInstance(this.myProject);
        for (AntBuildFile buildFile : antConfiguration.getBuildFiles()) {
            if (!vFile.equals(buildFile.getVirtualFile())) continue;
            AntBuildTarget target = buildFile.getModel().findTarget(targetName);
            if (target != null) {
                return target;
            }
            for (AntBuildTarget metaTarget : antConfiguration.getMetaTargets(buildFile)) {
                if (!targetName.equals(metaTarget.getName())) continue;
                return metaTarget;
            }
            return null;
        }
        return null;
    }

    public void handleTargetRename(String oldName, String newName) {
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)this.myProject);
        for (AntBeforeRunTask task : runManager.getBeforeRunTasks(ID, false)) {
            if (!oldName.equals(task.getTargetName())) continue;
            task.setTargetName(newName);
        }
    }
}

