/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.junit.JUnitProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryConfiguration;
import com.intellij.ide.macro.Macro;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.lang.ant.config.execution.AntCommandLineBuilder;
import com.intellij.lang.ant.config.execution.OutputParser;
import com.intellij.lang.ant.config.execution.OutputParser2;
import com.intellij.lang.ant.config.execution.RunCanceledException;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ExecutionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ant.execution.ExecutionHandler");
    @NonNls
    public static final String PARSER_JAR = "xerces1.jar";

    private ExecutionHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runBuild(final AntBuildFileBase buildFile, String[] targets, AntBuildMessageView buildMessageViewToReuse, DataContext dataContext, final @NotNull AntBuildListener antBuildListener) {
        GeneralCommandLine commandLine;
        AntBuildMessageView messageView;
        AntCommandLineBuilder builder;
        if (antBuildListener == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/lang/ant/config/execution/ExecutionHandler.runBuild must not be null");
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        AntCommandLineBuilder antCommandLineBuilder = builder = new AntCommandLineBuilder();
        synchronized (antCommandLineBuilder) {
            Project project = buildFile.getProject();
            try {
                builder.setBuildFile(buildFile.getAllOptions(), VfsUtil.virtualToIoFile((VirtualFile)buildFile.getVirtualFile()));
                builder.calculateProperties(dataContext);
                builder.addTargets(targets);
                builder.getCommandLine().setCharset(EncodingProjectManager.getInstance((Project)buildFile.getProject()).getDefaultCharset());
                messageView = ExecutionHandler.prepareMessageView(buildMessageViewToReuse, buildFile, targets);
                commandLine = CommandLineBuilder.createFromJavaParameters((SimpleJavaParameters)builder.getCommandLine());
                messageView.setBuildCommandLine(commandLine.getCommandLineString());
            }
            catch (RunCanceledException e) {
                e.showMessage(project, AntBundle.message("run.ant.erorr.dialog.title", new Object[0]));
                antBuildListener.buildFinished(2, 0);
                return;
            }
            catch (CantRunException e) {
                ExecutionErrorDialog.show((ExecutionException)e, (String)AntBundle.message("cant.run.ant.erorr.dialog.title", new Object[0]), (Project)project);
                antBuildListener.buildFinished(2, 0);
                return;
            }
            catch (Macro.ExecutionCancelledException e) {
                antBuildListener.buildFinished(1, 0);
                return;
            }
            catch (Throwable e) {
                antBuildListener.buildFinished(2, 0);
                LOG.error(e);
                return;
            }
        }
        final boolean startInBackground = buildFile.isRunInBackground();
        new Task.Backgroundable(null, AntBundle.message("ant.build.progress.dialog.title", new Object[0]), true){

            public boolean shouldStartInBackground() {
                return startInBackground;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/config/execution/ExecutionHandler$1.run must not be null");
                }
                try {
                    ExecutionHandler.runBuild(indicator, messageView, buildFile, antBuildListener, commandLine);
                }
                catch (Throwable e) {
                    LOG.error(e);
                    antBuildListener.buildFinished(2, 0);
                }
            }
        }.queue();
    }

    private static void runBuild(ProgressIndicator progress, @NotNull AntBuildMessageView errorView, @NotNull AntBuildFile buildFile, @NotNull AntBuildListener antBuildListener, @NotNull GeneralCommandLine commandLine) {
        JUnitProcessHandler handler;
        if (errorView == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/config/execution/ExecutionHandler.runBuild must not be null");
        }
        if (buildFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/ant/config/execution/ExecutionHandler.runBuild must not be null");
        }
        if (antBuildListener == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/lang/ant/config/execution/ExecutionHandler.runBuild must not be null");
        }
        if (commandLine == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/lang/ant/config/execution/ExecutionHandler.runBuild must not be null");
        }
        final Project project = buildFile.getProject();
        long startTime = new Date().getTime();
        if (LocalHistoryConfiguration.getInstance().ADD_LABEL_ON_RUNNING) {
            LocalHistory.putSystemLabel((Project)project, (String)AntBundle.message("ant.build.local.history.label", buildFile.getName()));
        }
        try {
            handler = JUnitProcessHandler.runCommandLine((GeneralCommandLine)commandLine);
        }
        catch (ExecutionException e) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExecutionErrorDialog.show((ExecutionException)e, (String)AntBundle.message("could.not.start.process.erorr.dialog.title", new Object[0]), (Project)project);
                }
            });
            antBuildListener.buildFinished(2, 0);
            return;
        }
        ExecutionHandler.processRunningAnt(progress, handler, errorView, buildFile, startTime, antBuildListener);
        handler.waitFor();
    }

    private static void processRunningAnt(final ProgressIndicator progress, JUnitProcessHandler handler, final AntBuildMessageView errorView, AntBuildFile buildFile, final long startTime, final AntBuildListener antBuildListener) {
        final Project project = buildFile.getProject();
        WindowManager.getInstance().getStatusBar(project).setInfo(AntBundle.message("ant.build.started.status.message", new Object[0]));
        final CheckCancelTask checkCancelTask = new CheckCancelTask(progress, (OSProcessHandler)handler);
        checkCancelTask.start(0L);
        final OutputParser parser = OutputParser2.attachParser(project, handler, errorView, progress, buildFile);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                checkCancelTask.cancel();
                parser.setStopped(true);
                errorView.stopScrollerThread();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (project.isDisposed()) {
                            return;
                        }
                        errorView.removeProgressPanel();
                        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
                        if (toolWindow != null) {
                            toolWindow.activate(null, false);
                            long buildTime = new Date().getTime() - startTime;
                            errorView.buildFinished(progress != null && progress.isCanceled(), buildTime, antBuildListener);
                        }
                    }
                }, ModalityState.NON_MODAL);
            }
        });
        handler.startNotify();
        errorView.startScrollerThread();
    }

    private static AntBuildMessageView prepareMessageView(AntBuildMessageView buildMessageViewToReuse, AntBuildFileBase buildFile, String[] targets) throws RunCanceledException {
        AntBuildMessageView messageView;
        if (buildMessageViewToReuse != null) {
            messageView = buildMessageViewToReuse;
            messageView.emptyAll();
        } else {
            messageView = AntBuildMessageView.openBuildMessageView(buildFile.getProject(), buildFile, targets);
            if (messageView == null) {
                throw new RunCanceledException(AntBundle.message("canceled.by.user.error.message", new Object[0]));
            }
        }
        return messageView;
    }

    static final class CheckCancelTask
    implements Runnable {
        private final ProgressIndicator myProgressIndicator;
        private final OSProcessHandler myProcessHandler;
        private volatile boolean myCanceled;

        public CheckCancelTask(ProgressIndicator progressIndicator, OSProcessHandler process) {
            this.myProgressIndicator = progressIndicator;
            this.myProcessHandler = process;
        }

        public void cancel() {
            this.myCanceled = true;
        }

        @Override
        public void run() {
            if (!this.myCanceled) {
                try {
                    this.myProgressIndicator.checkCanceled();
                    this.start(50L);
                }
                catch (ProcessCanceledException e) {
                    this.myProcessHandler.destroyProcess();
                }
            }
        }

        public void start(long delay) {
            JobScheduler.getScheduler().schedule(this, delay, TimeUnit.MILLISECONDS);
        }
    }
}

