/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntStructureViewBuilderFactory
implements PsiStructureViewFactory {
    public static final String UNNAMED = AntBundle.message("unnamed.string.presentation", new Object[0]);

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(PsiFile psiFile) {
        final AntFile antFile = AntSupport.getAntFile(psiFile);
        if (antFile != null) {
            return new TreeBasedStructureViewBuilder(){

                @NotNull
                public StructureViewModel createStructureViewModel() {
                    StructureViewModelBase structureViewModelBase = new StructureViewModelBase((PsiFile)antFile, (StructureViewTreeElement)new AntFileTreeElement(antFile)).withSuitableClasses(new Class[]{AntFile.class, AntTarget.class});
                    if (structureViewModelBase == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/AntStructureViewBuilderFactory$1.createStructureViewModel must not return null");
                    }
                    return structureViewModelBase;
                }
            };
        }
        return null;
    }

    static class AntTargetTreeElement
    extends PsiTreeElementBase<AntTarget> {
        public AntTargetTreeElement(AntTarget target) {
            super((PsiElement)target);
        }

        public String getPresentableText() {
            AntTarget value = (AntTarget)this.getValue();
            String name = value != null ? value.getName() : null;
            return name != null ? name : UNNAMED;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            ArrayList<StructureViewTreeElement> arrayList = new ArrayList<StructureViewTreeElement>();
            if (arrayList == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/ant/AntStructureViewBuilderFactory$AntTargetTreeElement.getChildrenBase must not return null");
            }
            return arrayList;
        }
    }

    static class AntFileTreeElement
    extends PsiTreeElementBase<AntFile> {
        public AntFileTreeElement(AntFile antFile) {
            super((PsiElement)antFile);
        }

        private AntProject getAntProject() {
            return ((AntFile)this.getValue()).getAntProject();
        }

        public String getPresentableText() {
            String name = this.getAntProject().getName();
            return name != null ? name : UNNAMED;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            ArrayList<StructureViewTreeElement> list = new ArrayList<StructureViewTreeElement>();
            for (AntTarget target : this.getAntProject().getTargets()) {
                list.add((StructureViewTreeElement)new AntTargetTreeElement(target));
            }
            Collections.sort(list, Sorter.ALPHA_SORTER.getComparator());
            ArrayList<StructureViewTreeElement> arrayList = list;
            if (arrayList == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/ant/AntStructureViewBuilderFactory$AntFileTreeElement.getChildrenBase must not return null");
            }
            return arrayList;
        }
    }
}

