/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFramework;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.xml.NanoXmlUtil;
import com.theoryinpractice.testng.model.TestClassFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.testng.Assert;
import org.testng.TestNG;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Configuration;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.ObjectFactory;
import org.testng.annotations.Test;

public class TestNGUtil
implements TestFramework {
    private static final Logger LOGGER = Logger.getInstance((String)"TestNG Runner");
    public static final String TESTNG_GROUP_NAME = "TestNG";
    public static final String TEST_ANNOTATION_FQN = Test.class.getName();
    public static final String[] CONFIG_ANNOTATIONS_FQN = new String[]{Configuration.class.getName(), Factory.class.getName(), ObjectFactory.class.getName(), DataProvider.class.getName(), BeforeClass.class.getName(), BeforeGroups.class.getName(), BeforeMethod.class.getName(), BeforeSuite.class.getName(), BeforeTest.class.getName(), AfterClass.class.getName(), AfterGroups.class.getName(), AfterMethod.class.getName(), AfterSuite.class.getName(), AfterTest.class.getName()};
    @NonNls
    private static final String[] CONFIG_JAVADOC_TAGS = new String[]{"testng.configuration", "testng.before-class", "testng.before-groups", "testng.before-method", "testng.before-suite", "testng.before-test", "testng.after-class", "testng.after-groups", "testng.after-method", "testng.after-suite", "testng.after-test"};
    static final List<String> junitAnnotions = Arrays.asList("org.junit.Test", "org.junit.Before", "org.junit.BeforeClass", "org.junit.After", "org.junit.AfterClass");
    private static final Logger LOG = Logger.getInstance((String)("#" + TestNGUtil.class.getName()));
    @NonNls
    private static final String SUITE_TAG_NAME = "suite";

    public static boolean hasConfig(PsiModifierListOwner element) {
        PsiMethod[] methods = element instanceof PsiClass ? ((PsiClass)element).getMethods() : new PsiMethod[]{(PsiMethod)element};
        for (PsiMethod method : methods) {
            for (String string : CONFIG_ANNOTATIONS_FQN) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)string, (boolean)false)) continue;
                return true;
            }
            for (String string : method.getChildren()) {
                if (!(string instanceof PsiDocComment)) continue;
                PsiDocComment doc = (PsiDocComment)string;
                for (String javadocTag : CONFIG_JAVADOC_TAGS) {
                    if (doc.findTagByName(javadocTag) == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isTestNGAnnotation(PsiAnnotation annotation) {
        String qName = annotation.getQualifiedName();
        if (qName.equals(TEST_ANNOTATION_FQN)) {
            return true;
        }
        for (String qn : CONFIG_ANNOTATIONS_FQN) {
            if (!qName.equals(qn)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTest(PsiModifierListOwner element) {
        return TestNGUtil.hasTest(element, true);
    }

    public static boolean hasTest(PsiModifierListOwner element, boolean checkDisabled) {
        return TestNGUtil.hasTest(element, checkDisabled, true);
    }

    public static boolean hasTest(PsiModifierListOwner element, boolean checkDisabled, boolean checkJavadoc) {
        PsiClass psiClass;
        boolean hasAnnotation = AnnotationUtil.isAnnotated((PsiModifierListOwner)element, (String)TEST_ANNOTATION_FQN, (boolean)false, (boolean)true);
        if (hasAnnotation) {
            if (checkDisabled) {
                PsiNameValuePair[] attribs;
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)element, (boolean)true, (String[])new String[]{TEST_ANNOTATION_FQN});
                assert (annotation != null);
                for (PsiNameValuePair attrib : attribs = annotation.getParameterList().getAttributes()) {
                    String attribName = attrib.getName();
                    PsiAnnotationMemberValue attribValue = attrib.getValue();
                    if (!Comparing.strEqual((String)attribName, (String)"enabled") || attribValue == null || !attribValue.textMatches((CharSequence)"false")) continue;
                    return false;
                }
            }
            return true;
        }
        if (element instanceof PsiDocCommentOwner && TestNGUtil.hasTestJavaDoc((PsiDocCommentOwner)element, checkJavadoc)) {
            return true;
        }
        if (element instanceof PsiClass) {
            PsiClass psiClass2 = (PsiClass)element;
            for (PsiMethod method : psiClass2.getAllMethods()) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)TEST_ANNOTATION_FQN, (boolean)false, (boolean)true)) {
                    return true;
                }
                if (!TestNGUtil.hasTestJavaDoc((PsiDocCommentOwner)method, checkJavadoc)) continue;
                return true;
            }
        } else if (element instanceof PsiMethod && (psiClass = ((PsiMethod)element).getContainingClass()) != null) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)TEST_ANNOTATION_FQN, (boolean)false, (boolean)true)) {
                boolean isPrivate = element.hasModifierProperty("private");
                return !isPrivate;
            }
            if (TestNGUtil.hasTestJavaDoc((PsiDocCommentOwner)psiClass, checkJavadoc)) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasTestJavaDoc(@NotNull PsiDocCommentOwner element, boolean checkJavadoc) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/util/TestNGUtil.hasTestJavaDoc must not be null");
        }
        if (checkJavadoc) {
            return TestNGUtil.getTextJavaDoc(element) != null;
        }
        return false;
    }

    private static PsiDocTag getTextJavaDoc(@NotNull PsiDocCommentOwner element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/util/TestNGUtil.getTextJavaDoc must not be null");
        }
        PsiDocComment docComment = element.getDocComment();
        if (docComment != null) {
            return docComment.findTagByName("testng.test");
        }
        return null;
    }

    private static boolean isBrokenPsiClass(PsiClass psiClass) {
        return psiClass == null || psiClass instanceof PsiAnonymousClass || psiClass instanceof JspClass;
    }

    public static Map<PsiClass, Collection<PsiMethod>> filterAnnotations(String parameter, Set<String> values, Collection<PsiClass> classes) {
        HashMap<PsiClass, Collection<PsiMethod>> results = new HashMap<PsiClass, Collection<PsiMethod>>();
        HashSet<String> test = new HashSet<String>(1);
        test.add(TEST_ANNOTATION_FQN);
        test.addAll(Arrays.asList(CONFIG_ANNOTATIONS_FQN));
        for (PsiClass psiClass : classes) {
            PsiMethod[] methods;
            PsiAnnotation annotation;
            block9: {
                block8: {
                    if (TestNGUtil.isBrokenPsiClass(psiClass)) continue;
                    try {
                        annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, test);
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception trying to findAnnotation on " + psiClass.getClass().getName() + ".\n\n" + e.getMessage());
                        annotation = null;
                    }
                    if (annotation == null) break block8;
                    if (!TestNGUtil.isAnnotatedWithParameter(annotation, parameter, values)) break block9;
                    results.put(psiClass, new LinkedHashSet());
                    break block9;
                }
                Collection<String> matches = TestNGUtil.extractAnnotationValuesFromJavaDoc(TestNGUtil.getTextJavaDoc((PsiDocCommentOwner)psiClass), parameter);
                for (String s : matches) {
                    if (!values.contains(s)) continue;
                    results.put(psiClass, new LinkedHashSet());
                    break;
                }
            }
            for (PsiMethod method : methods = psiClass.getMethods()) {
                if (method == null) continue;
                annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, test);
                if (annotation != null) {
                    if (!TestNGUtil.isAnnotatedWithParameter(annotation, parameter, values)) continue;
                    if (results.get(psiClass) == null) {
                        results.put(psiClass, new LinkedHashSet());
                    }
                    ((Collection)results.get(psiClass)).add(method);
                    continue;
                }
                Collection<String> matches = TestNGUtil.extractAnnotationValuesFromJavaDoc(TestNGUtil.getTextJavaDoc((PsiDocCommentOwner)psiClass), parameter);
                for (String s : matches) {
                    if (!values.contains(s)) continue;
                    ((Collection)results.get(psiClass)).add(method);
                }
            }
        }
        return results;
    }

    public static boolean isAnnotatedWithParameter(PsiAnnotation annotation, String parameter, Set<String> values) {
        PsiNameValuePair[] pair;
        for (PsiNameValuePair aPair : pair = annotation.getParameterList().getAttributes()) {
            if (!parameter.equals(aPair.getName())) continue;
            Collection<String> matches = TestNGUtil.extractValuesFromParameter(aPair);
            for (String s : matches) {
                if (!values.contains(s)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> getAnnotationValues(String parameter, PsiClass ... classes) {
        HashSet<String> results = new HashSet<String>();
        TestNGUtil.collectAnnotationValues(results, parameter, null, classes);
        return results;
    }

    public static void collectAnnotationValues(final Set<String> results, final String parameter, PsiMethod[] psiMethods, PsiClass ... classes) {
        final HashSet<String> test = new HashSet<String>(1);
        test.add(TEST_ANNOTATION_FQN);
        test.addAll(Arrays.asList(CONFIG_ANNOTATIONS_FQN));
        if (psiMethods != null) {
            for (final PsiMethod psiMethod : psiMethods) {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        TestNGUtil.appendAnnotationAttributeValues(parameter, results, AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMethod, (Set)test), (PsiDocCommentOwner)psiMethod);
                    }
                });
            }
        } else {
            for (final PsiClass psiClass : classes) {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (psiClass != null && TestNGUtil.hasTest((PsiModifierListOwner)psiClass)) {
                            PsiMethod[] methods;
                            TestNGUtil.appendAnnotationAttributeValues(parameter, results, AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (Set)test), (PsiDocCommentOwner)psiClass);
                            for (PsiMethod method : methods = psiClass.getMethods()) {
                                if (method == null) continue;
                                TestNGUtil.appendAnnotationAttributeValues(parameter, results, AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (Set)test), (PsiDocCommentOwner)method);
                            }
                        }
                    }
                });
            }
        }
    }

    private static void appendAnnotationAttributeValues(String parameter, Collection<String> results, PsiAnnotation annotation, PsiDocCommentOwner commentOwner) {
        if (annotation != null) {
            PsiNameValuePair[] pair;
            for (PsiNameValuePair aPair : pair = annotation.getParameterList().getAttributes()) {
                if (!parameter.equals(aPair.getName())) continue;
                results.addAll(TestNGUtil.extractValuesFromParameter(aPair));
            }
        } else {
            results.addAll(TestNGUtil.extractAnnotationValuesFromJavaDoc(TestNGUtil.getTextJavaDoc(commentOwner), parameter));
        }
    }

    private static Collection<String> extractAnnotationValuesFromJavaDoc(PsiDocTag tag, String parameter) {
        if (tag == null) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>();
        Matcher matcher = Pattern.compile("\\@testng.test(?:.*)" + parameter + "\\s*=\\s*\"(.*?)\".*").matcher(tag.getText());
        if (matcher.matches()) {
            String[] groups;
            for (String group : groups = matcher.group(1).split("[,\\s]")) {
                String trimmed = group.trim();
                if (trimmed.length() <= 0) continue;
                results.add(trimmed);
            }
        }
        return results;
    }

    private static Collection<String> extractValuesFromParameter(PsiNameValuePair aPair) {
        ArrayList<String> results = new ArrayList<String>();
        PsiAnnotationMemberValue value = aPair.getValue();
        if (value instanceof PsiArrayInitializerMemberValue) {
            for (PsiElement child : value.getChildren()) {
                if (!(child instanceof PsiLiteralExpression)) continue;
                results.add((String)((PsiLiteralExpression)child).getValue());
            }
        } else if (value instanceof PsiLiteralExpression) {
            results.add((String)((PsiLiteralExpression)value).getValue());
        }
        return results;
    }

    public static PsiClass[] getAllTestClasses(final TestClassFilter filter, boolean sync) {
        final PsiClass[][] holder = new PsiClass[1][];
        Runnable process = new Runnable(){

            @Override
            public void run() {
                final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                final HashSet set = new HashSet();
                PsiManager manager = PsiManager.getInstance((Project)filter.getProject());
                GlobalSearchScope scope = filter.getScope();
                GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)manager.getProject());
                scope = projectScope.intersectWith(scope);
                for (final PsiClass psiClass : AllClassesSearch.search((SearchScope)scope, (Project)manager.getProject())) {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            if (filter.isAccepted(psiClass)) {
                                indicator.setText2("Found test class " + psiClass.getQualifiedName());
                                set.add(psiClass);
                            }
                        }
                    });
                }
                holder[0] = set.toArray(new PsiClass[set.size()]);
            }
        };
        if (sync) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(process, "Searching For Tests...", true, filter.getProject());
        } else {
            process.run();
        }
        return holder[0];
    }

    public static PsiAnnotation[] getTestNGAnnotations(PsiElement element) {
        PsiElement[] annotations = PsiTreeUtil.collectElements((PsiElement)element, (PsiElementFilter)new PsiElementFilter(){

            public boolean isAccepted(PsiElement element) {
                if (!(element instanceof PsiAnnotation)) {
                    return false;
                }
                String name = ((PsiAnnotation)element).getQualifiedName();
                if (null == name) {
                    return false;
                }
                return name.startsWith("org.testng.annotations");
            }
        });
        PsiAnnotation[] array = new PsiAnnotation[annotations.length];
        System.arraycopy(annotations, 0, array, 0, annotations.length);
        return array;
    }

    public boolean isTestKlass(PsiClass psiClass) {
        return TestNGUtil.isTestNGClass(psiClass);
    }

    public static boolean isTestNGClass(PsiClass psiClass) {
        return TestNGUtil.hasTest((PsiModifierListOwner)psiClass, true, false);
    }

    public PsiMethod findSetUpMethod(PsiClass psiClass) throws IncorrectOperationException {
        PsiModifierList modifierList;
        PsiMethod[] methods;
        PsiManager manager = psiClass.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        PsiMethod patternMethod = factory.createMethodFromText("@org.testng.annotations.BeforeMethod\n protected void setUp() throws Exception {}", null);
        PsiClass superClass = psiClass.getSuperClass();
        if (superClass != null && (methods = superClass.findMethodsBySignature(patternMethod, false)).length > 0 && !(modifierList = methods[0].getModifierList()).hasModifierProperty("private")) {
            String pattern = "@org.testng.annotations.BeforeMethod\n";
            if (modifierList.hasModifierProperty("protected")) {
                pattern = pattern + "protected ";
            } else if (modifierList.hasModifierProperty("public")) {
                pattern = pattern + "public ";
            }
            patternMethod = factory.createMethodFromText(pattern + "void setUp() throws Exception {\nsuper.setUp();\n}", null);
        }
        PsiMethod[] psiMethods = psiClass.getMethods();
        PsiMethod inClass = null;
        for (PsiMethod psiMethod : psiMethods) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)BeforeMethod.class.getName(), (boolean)false)) continue;
            inClass = psiMethod;
            break;
        }
        if (inClass == null) {
            PsiMethod psiMethod = (PsiMethod)psiClass.add((PsiElement)patternMethod);
            JavaCodeStyleManager.getInstance((Project)psiClass.getProject()).shortenClassReferences((PsiElement)psiClass);
            return psiMethod;
        }
        if (inClass.getBody() == null) {
            return (PsiMethod)inClass.replace((PsiElement)patternMethod);
        }
        return inClass;
    }

    public boolean isTestMethodOrConfig(PsiMethod psiMethod) {
        return TestNGUtil.hasTest((PsiModifierListOwner)psiMethod) || TestNGUtil.hasConfig((PsiModifierListOwner)psiMethod);
    }

    public static boolean checkTestNGInClasspath(PsiElement psiElement) {
        Project project = psiElement.getProject();
        PsiManager manager = PsiManager.getInstance((Project)project);
        if (JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(TestNG.class.getName(), psiElement.getResolveScope()) == null) {
            if (!ApplicationManager.getApplication().isUnitTestMode() && Messages.showOkCancelDialog((Project)psiElement.getProject(), (String)"TestNG will be added to module classpath", (String)"Unable to convert.", (Icon)Messages.getWarningIcon()) != 0) {
                return false;
            }
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiElement);
            if (module == null) {
                return false;
            }
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            Library.ModifiableModel libraryModel = model.getModuleLibraryTable().createLibrary().getModifiableModel();
            String url = VfsUtil.getUrlForLibraryRoot((File)new File(PathUtil.getJarPathForClass(Assert.class)));
            VirtualFile libVirtFile = VirtualFileManager.getInstance().findFileByUrl(url);
            libraryModel.addRoot(libVirtFile, OrderRootType.CLASSES);
            libraryModel.commit();
            model.commit();
        }
        return true;
    }

    public static boolean containsJunitAnnotions(PsiClass psiClass) {
        if (psiClass != null) {
            for (PsiMethod method : psiClass.getMethods()) {
                if (!TestNGUtil.containsJunitAnnotions(method)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsJunitAnnotions(PsiMethod method) {
        return method != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, junitAnnotions);
    }

    public static boolean inheritsJUnitTestCase(PsiClass psiClass) {
        PsiClass current = psiClass;
        while (current != null) {
            PsiClass[] supers = current.getSupers();
            if (supers.length > 0) {
                PsiClass parent = supers[0];
                if ("junit.framework.TestCase".equals(parent.getQualifiedName())) {
                    return true;
                }
                current = parent;
                if (current != psiClass) continue;
                return false;
            }
            current = null;
        }
        return false;
    }

    public static boolean inheritsITestListener(PsiClass psiClass) {
        final boolean[] inherits = new boolean[1];
        InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)false, (Processor)new Processor<PsiClass>(){

            public boolean process(PsiClass superClass) {
                String qualifiedName = superClass.getQualifiedName();
                if (qualifiedName != null && qualifiedName.matches("org.testng.(IReporter|ITestListener|IMethodInterceptor|IInvokedMethodListener|internal.annotations.IAnnotationTransformer)")) {
                    inherits[0] = true;
                    return false;
                }
                return true;
            }
        });
        return inherits[0];
    }

    public static boolean isTestngXML(VirtualFile virtualFile) {
        String result;
        return virtualFile.getName().endsWith("xml") && (result = NanoXmlUtil.parseHeader((VirtualFile)virtualFile).getRootTagLocalName()) != null && result.equals(SUITE_TAG_NAME);
    }
}

