/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependsOnMethodInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOGGER = Logger.getInstance((String)"TestNG Runner");
    private static final Pattern PATTERN = Pattern.compile("\"([a-zA-Z1-9_\\(\\)]*)\"");
    private static final ProblemDescriptor[] EMPTY = new ProblemDescriptor[0];

    @NotNull
    public String getGroupDisplayName() {
        if ("TestNG" == null) {
            throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/DependsOnMethodInspection.getGroupDisplayName must not return null");
        }
        return "TestNG";
    }

    @NotNull
    public String getDisplayName() {
        if ("dependsOnMethods problem" == null) {
            throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/DependsOnMethodInspection.getDisplayName must not return null");
        }
        return "dependsOnMethods problem";
    }

    @NotNull
    public String getShortName() {
        if ("dependsOnMethodTestNG" == null) {
            throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/DependsOnMethodInspection.getShortName must not return null");
        }
        return "dependsOnMethodTestNG";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/inspection/DependsOnMethodInspection.checkClass must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/theoryinpractice/testng/inspection/DependsOnMethodInspection.checkClass must not be null");
        }
        if (!psiClass.getContainingFile().isWritable()) {
            return null;
        }
        PsiAnnotation[] annotations = TestNGUtil.getTestNGAnnotations((PsiElement)psiClass);
        if (annotations.length == 0) {
            return EMPTY;
        }
        ArrayList<ProblemDescriptor> problemDescriptors = new ArrayList<ProblemDescriptor>();
        for (PsiAnnotation annotation : annotations) {
            PsiNameValuePair[] params;
            PsiNameValuePair dep = null;
            for (PsiNameValuePair param : params = annotation.getParameterList().getAttributes()) {
                if (!"dependsOnMethods".equals(param.getName())) continue;
                dep = param;
                break;
            }
            if (dep == null || dep.getValue() == null) continue;
            Matcher matcher = PATTERN.matcher(dep.getValue().getText());
            while (matcher.find()) {
                String methodName = matcher.group(1);
                DependsOnMethodInspection.checkMethodNameDependency(manager, psiClass, methodName, dep, problemDescriptors, isOnTheFly);
            }
        }
        return problemDescriptors.toArray(new ProblemDescriptor[0]);
    }

    private static void checkMethodNameDependency(InspectionManager manager, PsiClass psiClass, String methodName, PsiNameValuePair dep, List<ProblemDescriptor> problemDescriptors, boolean onTheFly) {
        LOGGER.debug("Found dependsOnMethods with text: " + methodName);
        if (methodName.length() > 0 && methodName.charAt(methodName.length() - 1) == ')') {
            LOGGER.debug("dependsOnMethods contains ()" + psiClass.getName());
            ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)dep, "Method '" + methodName + "' should not include () characters.", (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly);
            problemDescriptors.add(descriptor);
        } else {
            PsiMethod[] foundMethods = psiClass.findMethodsByName(methodName, true);
            if (foundMethods.length == 0) {
                LOGGER.debug("dependsOnMethods method doesn't exist:" + methodName);
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)dep, "Method '" + methodName + "' unknown.", (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly);
                problemDescriptors.add(descriptor);
            } else {
                boolean hasTestsOrConfigs = false;
                for (PsiMethod foundMethod : foundMethods) {
                    hasTestsOrConfigs |= TestNGUtil.hasTest((PsiModifierListOwner)foundMethod) || TestNGUtil.hasConfig((PsiModifierListOwner)foundMethod);
                }
                if (!hasTestsOrConfigs) {
                    ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)dep, "Method '" + methodName + "' is not a test or configuration method.", (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly);
                    problemDescriptors.add(descriptor);
                }
            }
        }
    }
}

