/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.util.ArrayList;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NonNls;

class OptionTagBinding
implements Binding {
    private static final Logger LOG = Logger.getInstance("#" + OptionTagBinding.class.getName());
    private final Accessor accessor;
    private final String myName;
    private final Binding myBinding;

    public OptionTagBinding(Accessor accessor, XmlSerializerImpl xmlSerializer) {
        this.accessor = accessor;
        this.myName = accessor.getName();
        this.myBinding = xmlSerializer.getBinding(accessor);
    }

    @Override
    public Object serialize(Object o, Object context) {
        Element targetElement = new Element("option");
        Object value = this.accessor.read(o);
        targetElement.setAttribute("name", this.myName);
        if (value == null) {
            return targetElement;
        }
        Object node = this.myBinding.serialize(value, targetElement);
        if (node instanceof Text) {
            Text text = (Text)node;
            targetElement.setAttribute("value", text.getText());
        } else if (targetElement != node) {
            JDOMUtil.addContent(targetElement, node);
        }
        return targetElement;
    }

    @Override
    public Object deserialize(Object o, Object ... nodes) {
        if (nodes.length > 1) {
            LOG.info("Duplicate options for " + o + " will be ignored");
        }
        assert (nodes.length != 0) : "Empty nodes passed to: " + this;
        Element element = (Element)nodes[0];
        Attribute valueAttr = element.getAttribute("value");
        if (valueAttr != null) {
            Object value = this.myBinding.deserialize(o, valueAttr);
            this.accessor.write(o, value);
        } else {
            Content[] childElements = JDOMUtil.getContent(element);
            ArrayList<Content> children = new ArrayList<Content>();
            for (Content child : childElements) {
                if (XmlSerializerImpl.isIgnoredNode(child)) continue;
                children.add(child);
            }
            if (children.size() > 0) {
                Object value = this.myBinding.deserialize(this.accessor.read(o), ArrayUtil.toObjectArray(children));
                this.accessor.write(o, value);
            } else {
                this.accessor.write(o, null);
            }
        }
        return o;
    }

    @Override
    public boolean isBoundTo(Object node) {
        if (!(node instanceof Element)) {
            return false;
        }
        Element e = (Element)node;
        if (!e.getName().equals("option")) {
            return false;
        }
        String name = e.getAttributeValue("name");
        return name != null && name.equals(this.myName);
    }

    @Override
    public Class getBoundNodeType() {
        throw new UnsupportedOperationException("Method getBoundNodeType is not supported in " + this.getClass());
    }

    @Override
    public void init() {
    }

    @NonNls
    public String toString() {
        return "OptionTagBinding[" + this.myName + ", binding=" + this.myBinding + "]";
    }
}

