/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.Bits;
import com.intellij.util.io.PagedFileStorage;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentHashMapValueStorage {
    @Nullable
    private RAReader myCompactionModeReader = null;
    private long mySize;
    private final File myFile;
    private final String myPath;
    private boolean myCompactionMode = false;
    private static final int CACHE_PROTECTED_QUEUE_SIZE = 10;
    private static final int CACHE_PROBATIONAL_QUEUE_SIZE = 20;
    private static final FileAccessorCache<DataOutputStream> ourAppendersCache = new FileAccessorCache<DataOutputStream>(10, 20){

        @Override
        @NotNull
        public CacheValue<DataOutputStream> createValue(String path) {
            try {
                CachedAppender cachedAppender = new CachedAppender(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path, true))));
                if (cachedAppender == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentHashMapValueStorage$1.createValue must not return null");
                }
                return cachedAppender;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final FileAccessorCache<RAReader> ourReadersCache = new FileAccessorCache<RAReader>(10, 20){

        @Override
        @NotNull
        public CacheValue<RAReader> createValue(String path) {
            CachedReader cachedReader = new CachedReader(new FileReader(new File(path)));
            if (cachedReader == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentHashMapValueStorage$2.createValue must not return null");
            }
            return cachedReader;
        }
    };

    public PersistentHashMapValueStorage(String path) throws IOException {
        this.myPath = path;
        this.myFile = new File(path);
        this.mySize = this.myFile.length();
        if (this.mySize == 0L) {
            this.appendBytes("Header Record For PersistentHashMapValuStorage".getBytes(), 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long appendBytes(byte[] data, long prevChunkAddress) throws IOException {
        assert (!this.myCompactionMode);
        long result = this.mySize;
        CacheValue<DataOutputStream> appender = ourAppendersCache.get(this.myPath);
        try {
            appender.get().writeLong(prevChunkAddress);
            appender.get().writeInt(data.length);
            appender.get().write(data);
        }
        finally {
            appender.release();
        }
        this.mySize += (long)(data.length + 8 + 4);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readBytes(long tailChunkAddress, byte[] result) throws IOException {
        int size = result.length;
        if (size == 0) {
            return tailChunkAddress;
        }
        this.force();
        int bytesRead = 0;
        long chunk = tailChunkAddress;
        int chunkCount = 0;
        byte[] headerBits = new byte[12];
        RAReader reader = this.myCompactionModeReader;
        CacheValue<RAReader> readerHandle = null;
        if (reader == null) {
            readerHandle = ourReadersCache.get(this.myPath);
            reader = readerHandle.get();
        }
        try {
            while (chunk != 0L) {
                reader.get(chunk, headerBits, 0, 12);
                long prevChunkAddress = Bits.getLong(headerBits, 0);
                int chunkSize = Bits.getInt(headerBits, 8);
                int off = size - bytesRead - chunkSize;
                PersistentHashMapValueStorage.checkPreconditions(result, chunkSize, off);
                reader.get(chunk + 12L, result, off, chunkSize);
                chunk = prevChunkAddress;
                bytesRead += chunkSize;
                ++chunkCount;
            }
        }
        finally {
            if (readerHandle != null) {
                readerHandle.release();
            }
        }
        if (bytesRead != size) {
            throw new IOException("Read from storage " + bytesRead + " bytes, but requested " + size + " bytes");
        }
        if (chunkCount > 1 && !this.myCompactionMode) {
            return this.appendBytes(result, 0L);
        }
        return tailChunkAddress;
    }

    private static void checkPreconditions(byte[] result, int chunkSize, int off) throws IOException {
        if (chunkSize < 0) {
            throw new IOException("Value storage corrupted: negative chunk size");
        }
        if (off < 0) {
            throw new IOException("Value storage corrupted: negative offset");
        }
        if (chunkSize > result.length - off) {
            throw new IOException("Value storage corrupted");
        }
    }

    public void force() {
        CacheValue<DataOutputStream> cached = ourAppendersCache.getIfCached(this.myPath);
        if (cached != null) {
            try {
                cached.get().flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                cached.release();
            }
        }
    }

    public void dispose() {
        ourReadersCache.remove(this.myPath);
        ourAppendersCache.remove(this.myPath);
        if (this.myCompactionModeReader != null) {
            this.myCompactionModeReader.dispose();
            this.myCompactionModeReader = null;
        }
    }

    public void switchToCompactionMode(PagedFileStorage.StorageLock lock) {
        ourReadersCache.remove(this.myPath);
        try {
            this.myCompactionModeReader = new MappedReader(this.myFile, lock);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.myCompactionMode = true;
    }

    public static PersistentHashMapValueStorage create(String path) throws IOException {
        return new PersistentHashMapValueStorage(path);
    }

    private static abstract class CacheValue<T> {
        private final T myFileAccessor;
        private final AtomicInteger myRefCount = new AtomicInteger(1);

        private CacheValue(T fileAccessor) {
            this.myFileAccessor = fileAccessor;
        }

        public final void allocate() {
            this.myRefCount.incrementAndGet();
        }

        public final void release() {
            if (this.myRefCount.decrementAndGet() == 0) {
                this.disposeAccessor(this.myFileAccessor);
            }
        }

        public T get() {
            return this.myFileAccessor;
        }

        protected abstract void disposeAccessor(T var1);
    }

    private static class CachedReader
    extends CacheValue<RAReader> {
        private CachedReader(RAReader reader) {
            super(reader);
        }

        @Override
        protected void disposeAccessor(RAReader reader) {
            reader.dispose();
        }
    }

    private static class CachedAppender
    extends CacheValue<DataOutputStream> {
        private CachedAppender(DataOutputStream os) {
            super(os);
        }

        @Override
        protected void disposeAccessor(DataOutputStream os) {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static abstract class FileAccessorCache<T>
    extends SLRUCache<String, CacheValue<T>> {
        private final Object myLock = new Object();

        private FileAccessorCache(int protectedQueueSize, int probationalQueueSize) {
            super(protectedQueueSize, probationalQueueSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public final CacheValue<T> get(String key) {
            Object object = this.myLock;
            // MONITORENTER : object
            CacheValue value = (CacheValue)super.get(key);
            value.allocate();
            CacheValue cacheValue = value;
            // MONITOREXIT : object
            if (cacheValue != null) return cacheValue;
            throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentHashMapValueStorage$FileAccessorCache.get must not return null");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CacheValue<T> getIfCached(String key) {
            Object object = this.myLock;
            synchronized (object) {
                CacheValue value = (CacheValue)super.getIfCached(key);
                if (value != null) {
                    value.allocate();
                }
                return value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(String key) {
            Object object = this.myLock;
            synchronized (object) {
                return super.remove(key);
            }
        }

        @Override
        protected final void onDropFromCache(String key, CacheValue<T> value) {
            value.release();
        }
    }

    private static class FileReader
    implements RAReader {
        private final RandomAccessFile myFile;

        private FileReader(File file) {
            try {
                this.myFile = new RandomAccessFile(file, "r");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void get(long addr, byte[] dst, int off, int len) throws IOException {
            this.myFile.seek(addr);
            this.myFile.read(dst, off, len);
        }

        @Override
        public void dispose() {
            try {
                this.myFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class MappedReader
    implements RAReader {
        private final PagedFileStorage myHolder;

        private MappedReader(File file, PagedFileStorage.StorageLock lock) throws IOException {
            this.myHolder = new PagedFileStorage(file, lock);
            this.myHolder.length();
        }

        @Override
        public void get(long addr, byte[] dst, int off, int len) {
            this.myHolder.get((int)addr, dst, off, len);
        }

        @Override
        public void dispose() {
            this.myHolder.close();
        }
    }

    private static interface RAReader {
        public void get(long var1, byte[] var3, int var4, int var5) throws IOException;

        public void dispose();
    }
}

