/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.LimitedPool;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PersistentHashMap<Key, Value>
extends PersistentEnumerator<Key> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.PersistentHashMap");
    private PersistentHashMapValueStorage myValueStorage;
    private final DataExternalizer<Value> myValueExternalizer;
    private static final long NULL_ADDR = 0L;
    private static final int NULL_SIZE = 0;
    @NonNls
    public static final String DATA_FILE_EXTENSION = ".values";
    private final File myFile;
    private int myGarbageSize;
    private static final int VALUE_REF_OFFSET = 12;
    private final byte[] myRecordBuffer = new byte[24];
    private final LimitedPool<AppendStream> myStreamPool = new LimitedPool<AppendStream>(10, new LimitedPool.ObjectFactory<AppendStream>(){

        @Override
        public AppendStream create() {
            return new AppendStream();
        }

        @Override
        public void cleanup(AppendStream appendStream) {
            appendStream.reset();
        }
    });
    private final SLRUCache<Key, AppendStream> myAppendCache = new SLRUCache<Key, AppendStream>(16384, 4096){

        @Override
        @NotNull
        public AppendStream createValue(Key key) {
            AppendStream appendStream = (AppendStream)PersistentHashMap.this.myStreamPool.alloc();
            if (appendStream == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/io/PersistentHashMap$2.createValue must not return null");
            }
            return appendStream;
        }

        @Override
        protected void onDropFromCache(Key key, AppendStream value) {
            try {
                int id = PersistentHashMap.this.enumerate(key);
                HeaderRecord headerRecord = PersistentHashMap.this.readValueId(id);
                byte[] bytes = value.toByteArray();
                headerRecord.size += bytes.length;
                headerRecord.address = PersistentHashMap.this.myValueStorage.appendBytes(bytes, headerRecord.address);
                PersistentHashMap.this.updateValueId(id, headerRecord);
                PersistentHashMap.this.myStreamPool.recycle(value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public PersistentHashMap(File file, KeyDescriptor<Key> keyDescriptor, DataExternalizer<Value> valueExternalizer) throws IOException {
        this(file, keyDescriptor, valueExternalizer, 4096);
    }

    public PersistentHashMap(File file, KeyDescriptor<Key> keyDescriptor, DataExternalizer<Value> valueExternalizer, int initialSize) throws IOException {
        super(PersistentHashMap.checkDataFiles(file), keyDescriptor, initialSize);
        try {
            this.myFile = file;
            this.myValueExternalizer = valueExternalizer;
            this.myValueStorage = PersistentHashMapValueStorage.create(PersistentHashMap.getDataFile(this.myFile).getPath());
            this.myGarbageSize = this.getMetaData();
            if (this.makesSenceToCompact()) {
                this.compact();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.error(t);
            throw new PersistentEnumerator.CorruptedException(file);
        }
    }

    public File getBaseFile() {
        return this.myFile;
    }

    private boolean makesSenceToCompact() {
        long filesize = PersistentHashMap.getDataFile(this.myFile).length();
        return filesize > 0x500000L && (long)(this.myGarbageSize * 2) > filesize;
    }

    private static File checkDataFiles(File file) {
        if (!file.exists()) {
            File dataFile = PersistentHashMap.getDataFile(file);
            final String baseName = dataFile.getName();
            File[] files = dataFile.getParentFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().startsWith(baseName);
                }
            });
            if (files != null) {
                for (File f : files) {
                    FileUtil.delete(f);
                }
            }
        }
        return file;
    }

    private static File getDataFile(File file) {
        return new File(file.getParentFile(), file.getName() + DATA_FILE_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(Key key, Value value) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            this.markDirty(true);
            this.myAppendCache.remove(key);
            int id = this.enumerate(key);
            AppendStream record = new AppendStream();
            this.myValueExternalizer.save(record, value);
            byte[] bytes = record.toByteArray();
            HeaderRecord header = this.readValueId(id);
            if (header != null) {
                this.myGarbageSize += header.size;
            } else {
                header = new HeaderRecord();
            }
            header.size = bytes.length;
            header.address = this.myValueStorage.appendBytes(bytes, 0L);
            this.updateValueId(id, header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void appendData(Key key, ValueDataAppender appender) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            this.markDirty(true);
            appender.append(this.myAppendCache.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean processKeys(Processor<Key> processor) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            this.myAppendCache.clear();
            return this.iterateData(processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<Key> getAllKeysWithExistingMapping() throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            return this.getAllDataObjects(new PersistentEnumerator.DataFilter(){

                @Override
                public boolean accept(int id) {
                    try {
                        return ((PersistentHashMap)PersistentHashMap.this).readValueId((int)id).address != 0L;
                    }
                    catch (IOException iOException) {
                        return true;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Value get(Key key) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            this.myAppendCache.remove(key);
            int id = this.tryEnumerate(key);
            if (id == 0) {
                return null;
            }
            HeaderRecord header = this.readValueId(id);
            if (header.address == 0L) {
                return null;
            }
            byte[] data = new byte[header.size];
            long newAddress = this.myValueStorage.readBytes(header.address, data);
            if (newAddress != header.address) {
                this.markDirty(true);
                header.address = newAddress;
                this.updateValueId(id, header);
                this.myGarbageSize += header.size;
            }
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
            Value Value = this.myValueExternalizer.read(input);
            return Value;
            finally {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean containsMapping(Key key) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            this.myAppendCache.remove(key);
            int id = this.tryEnumerate(key);
            if (id == 0) {
                return false;
            }
            return this.readValueId((int)id).address != 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(Key key) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            this.myAppendCache.remove(key);
            int id = this.tryEnumerate(key);
            if (id == 0) {
                return;
            }
            this.markDirty(true);
            HeaderRecord record = this.readValueId(id);
            if (record != null) {
                this.myGarbageSize += record.size;
            }
            this.updateValueId(id, new HeaderRecord());
        }
    }

    public final void markDirty() throws IOException {
        this.markDirty(true);
    }

    @Override
    protected void markClean() throws IOException {
        this.putMetaData(this.myGarbageSize);
        super.markClean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void force() {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            try {
                this.myAppendCache.clear();
                this.myValueStorage.force();
            }
            finally {
                super.force();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            this.myAppendCache.clear();
            try {
                this.myValueStorage.dispose();
            }
            finally {
                super.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void compact() throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            long now = System.currentTimeMillis();
            String newPath = PersistentHashMap.getDataFile(this.myFile).getPath() + ".new";
            final PersistentHashMapValueStorage newStorage = PersistentHashMapValueStorage.create(newPath);
            this.myValueStorage.switchToCompactionMode(ourLock);
            this.traverseAllRecords(new PersistentEnumerator.RecordsProcessor(){

                @Override
                public boolean process(int keyId) throws IOException {
                    HeaderRecord record = PersistentHashMap.this.readValueId(keyId);
                    if (record.address != 0L) {
                        byte[] bytes = new byte[record.size];
                        PersistentHashMap.this.myValueStorage.readBytes(record.address, bytes);
                        record.address = newStorage.appendBytes(bytes, 0L);
                        PersistentHashMap.this.updateValueId(keyId, record);
                    }
                    return true;
                }
            });
            this.myValueStorage.dispose();
            newStorage.dispose();
            FileUtil.rename(new File(newPath), PersistentHashMap.getDataFile(this.myFile));
            this.myValueStorage = PersistentHashMapValueStorage.create(PersistentHashMap.getDataFile(this.myFile).getPath());
            LOG.info("Compacted " + this.myFile.getPath() + " in " + (System.currentTimeMillis() - now) + "ms.");
            this.myGarbageSize = 0;
        }
    }

    private HeaderRecord readValueId(int keyId) throws IOException {
        HeaderRecord result = new HeaderRecord();
        result.address = this.myStorage.getLong(keyId + 12);
        result.size = this.myStorage.getInt(keyId + 12 + 8);
        return result;
    }

    private void updateValueId(int keyId, HeaderRecord value) throws IOException {
        this.myStorage.putLong(keyId + 12, value.address);
        this.myStorage.putInt(keyId + 12 + 8, value.size);
    }

    @Override
    protected byte[] getRecordBuffer() {
        return this.myRecordBuffer;
    }

    @Override
    protected void setupRecord(int hashCode, int dataOffset, byte[] buf) {
        super.setupRecord(hashCode, dataOffset, buf);
        for (int i = 12; i < this.myRecordBuffer.length; ++i) {
            buf[i] = 0;
        }
    }

    private static class HeaderRecord {
        long address;
        int size;

        private HeaderRecord() {
        }
    }

    public static interface ValueDataAppender {
        public void append(DataOutput var1) throws IOException;
    }

    private static class AppendStream
    extends DataOutputStream {
        private AppendStream() {
            super(new ByteArrayOutputStream());
        }

        public void writeTo(OutputStream stream) throws IOException {
            ((ByteArrayOutputStream)this.out).writeTo(stream);
        }

        public void reset() {
            ((ByteArrayOutputStream)this.out).reset();
        }

        public byte[] toByteArray() {
            return ((ByteArrayOutputStream)this.out).toByteArray();
        }
    }
}

