/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MultiMap<K, V> {
    private final Map<K, Collection<V>> myMap = this.createMap();

    protected Map<K, Collection<V>> createMap() {
        return new HashMap();
    }

    protected Collection<V> createCollection() {
        return new ArrayList();
    }

    protected Collection<V> createEmptyCollection() {
        return Collections.emptyList();
    }

    public void putValue(K key, V value) {
        Collection<V> list = this.myMap.get(key);
        if (list == null) {
            list = this.createCollection();
            this.myMap.put(key, list);
        }
        list.add(value);
    }

    public boolean isEmpty() {
        for (Collection<V> valueList : this.myMap.values()) {
            if (valueList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean containsKey(K key) {
        return this.myMap.containsKey(key);
    }

    public boolean containsScalarValue(V value) {
        for (Collection<V> valueList : this.myMap.values()) {
            if (!valueList.contains(value)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<V> get(K key) {
        Collection<V> collection = this.myMap.get(key);
        Collection<V> collection2 = collection == null ? this.createEmptyCollection() : collection;
        if (collection2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/MultiMap.get must not return null");
        }
        return collection2;
    }

    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    public int size() {
        return this.myMap.size();
    }

    public void put(K key, Collection<V> values) {
        this.myMap.put(key, values);
    }

    public void removeValue(K key, V value) {
        Collection<V> values = this.myMap.get(key);
        values.remove(value);
        if (values.isEmpty()) {
            this.myMap.remove(key);
        }
    }

    public Collection<? extends V> values() {
        ArrayList<V> result = new ArrayList<V>();
        for (Collection<V> vs : this.myMap.values()) {
            result.addAll(vs);
        }
        return result;
    }

    public void clear() {
        this.myMap.clear();
    }

    public Collection<V> remove(K key) {
        return this.myMap.remove(key);
    }
}

