/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

public class LongArrayList
implements Cloneable {
    private long[] myData;
    private int mySize;

    public LongArrayList(int initialCapacity) {
        this.myData = new long[initialCapacity];
    }

    public LongArrayList() {
        this(10);
    }

    public void trimToSize() {
        int oldCapacity = this.myData.length;
        if (this.mySize < oldCapacity) {
            long[] oldData = this.myData;
            this.myData = new long[this.mySize];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            long[] oldData = this.myData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = new long[newCapacity];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public boolean contains(long elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(long elem) {
        for (int i = 0; i < this.mySize; ++i) {
            if (elem != this.myData[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long elem) {
        for (int i = this.mySize - 1; i >= 0; --i) {
            if (elem != this.myData[i]) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            LongArrayList v = (LongArrayList)super.clone();
            v.myData = new long[this.mySize];
            System.arraycopy(this.myData, 0, v.myData, 0, this.mySize);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public long[] toArray() {
        long[] result = new long[this.mySize];
        System.arraycopy(this.myData, 0, result, 0, this.mySize);
        return result;
    }

    public long[] toArray(long[] a) {
        if (a.length < this.mySize) {
            a = new long[this.mySize];
        }
        System.arraycopy(this.myData, 0, a, 0, this.mySize);
        return a;
    }

    public long get(int index) {
        this.checkRange(index);
        return this.myData[index];
    }

    public long set(int index, long element) {
        this.checkRange(index);
        long oldValue = this.myData[index];
        this.myData[index] = element;
        return oldValue;
    }

    public void add(long o) {
        this.ensureCapacity(this.mySize + 1);
        this.myData[this.mySize++] = o;
    }

    public void add(int index, long element) {
        if (index > this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        this.ensureCapacity(this.mySize + 1);
        System.arraycopy(this.myData, index, this.myData, index + 1, this.mySize - index);
        this.myData[index] = element;
        ++this.mySize;
    }

    public long remove(int index) {
        this.checkRange(index);
        long oldValue = this.myData[index];
        int numMoved = this.mySize - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.myData, index + 1, this.myData, index, numMoved);
        }
        --this.mySize;
        return oldValue;
    }

    public void clear() {
        this.mySize = 0;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.mySize - toIndex;
        System.arraycopy(this.myData, toIndex, this.myData, fromIndex, numMoved);
        this.mySize -= toIndex - fromIndex;
    }

    private void checkRange(int index) {
        if (index >= this.mySize || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
    }
}

