/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class EnvironmentUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.EnvironmentUtil");
    private static Map<String, String> ourEnviromentProperties;

    private EnvironmentUtil() {
    }

    @NonNls
    public static Map<String, String> getEnviromentProperties() {
        if (ourEnviromentProperties == null) {
            List vars = EnvironmentUtil.getProcEnvironment();
            ourEnviromentProperties = new HashMap<String, String>();
            if (vars != null) {
                for (String entry : vars) {
                    int pos = entry.indexOf(61);
                    if (pos == -1) continue;
                    String prop = entry.substring(0, pos);
                    String val = entry.substring(pos + 1);
                    ourEnviromentProperties.put(prop, val);
                }
            }
        }
        return ourEnviromentProperties;
    }

    public static String[] getFlattenEnvironmentProperties() {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, String> enviromentProperties = EnvironmentUtil.getEnviromentProperties();
        if (enviromentProperties != null) {
            for (String envName : enviromentProperties.keySet()) {
                result.add(envName + "=" + enviromentProperties.get(envName));
            }
        }
        return ArrayUtil.toStringArray(result);
    }

    private static synchronized List getProcEnvironment() {
        ArrayList<String> procEnvironment = new ArrayList<String>();
        try {
            String line;
            int b;
            String[] procEnvCommand = EnvironmentUtil.getProcEnvCommand();
            Process process = Runtime.getRuntime().exec(procEnvCommand);
            if (process == null) {
                return null;
            }
            InputStream processIn = process.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((b = processIn.read()) >= 0) {
                out.write(b);
            }
            int exitCode = process.waitFor();
            if (exitCode < 0) {
                return null;
            }
            BufferedReader in = new BufferedReader(new StringReader(out.toString()));
            String var = null;
            String lineSep = SystemProperties.getLineSeparator();
            while ((line = in.readLine()) != null) {
                if (line.indexOf(61) == -1) {
                    if (var == null) {
                        var = lineSep + line;
                        continue;
                    }
                    var = var + lineSep + line;
                    continue;
                }
                if (var != null) {
                    procEnvironment.add(var);
                }
                var = line;
            }
            if (var != null) {
                procEnvironment.add(var);
            }
        }
        catch (Throwable exc) {
            LOG.debug(exc);
        }
        return procEnvironment;
    }

    private static String[] getProcEnvCommand() {
        if (SystemInfo.isOS2) {
            String[] cmd = new String[]{"cmd", "/c", "set"};
            return cmd;
        }
        if (SystemInfo.isWindows) {
            if (!SystemInfo.isWindows9x) {
                String[] cmd = new String[]{"cmd", "/c", "set"};
                return cmd;
            }
            String[] cmd = new String[]{"command.com", "/c", "set"};
            return cmd;
        }
        if (SystemInfo.isUnix) {
            String[] cmd = new String[]{"/usr/bin/env"};
            return cmd;
        }
        return null;
    }

    public static String[] getEnvironment() {
        Map<String, String> enviroment = EnvironmentUtil.getEnviromentProperties();
        String[] envp = new String[enviroment.size()];
        int i = 0;
        for (String name : enviroment.keySet()) {
            String value = enviroment.get(name);
            envp[i++] = name + "=" + value;
        }
        return envp;
    }
}

