/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MethodOverridesStaticMethodInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("MethodOverridesStaticMethodOfSuperclass" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/MethodOverridesStaticMethodInspection.getID must not return null");
        }
        return "MethodOverridesStaticMethodOfSuperclass";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.overrides.static.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/MethodOverridesStaticMethodInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.overrides.static.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/MethodOverridesStaticMethodInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOverridesStaticMethodVisitor();
    }

    private static class MethodOverridesStaticMethodVisitor
    extends BaseInspectionVisitor {
        private MethodOverridesStaticMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/visibility/MethodOverridesStaticMethodInspection$MethodOverridesStaticMethodVisitor.visitMethod must not be null");
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            String methodName = method.getName();
            PsiParameterList parameterList = method.getParameterList();
            int parametersCount = parameterList.getParametersCount();
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            for (PsiClass ancestorClass = aClass.getSuperClass(); ancestorClass != null; ancestorClass = ancestorClass.getSuperClass()) {
                PsiMethod[] methods;
                if (!visitedClasses.add(ancestorClass)) {
                    return;
                }
                for (PsiMethod testMethod : methods = ancestorClass.findMethodsByName(methodName, false)) {
                    PsiParameterList testParametersList = testMethod.getParameterList();
                    int numTestParameters = testParametersList.getParametersCount();
                    if (parametersCount != numTestParameters || !testMethod.hasModifierProperty("static") || testMethod.hasModifierProperty("private")) continue;
                    this.registerMethodError(method, new Object[0]);
                    return;
                }
            }
        }
    }
}

