/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MethodOverloadsParentMethodInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("MethodOverloadsMethodOfSuperclass" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/MethodOverloadsParentMethodInspection.getID must not return null");
        }
        return "MethodOverloadsMethodOfSuperclass";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.overloads.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/MethodOverloadsParentMethodInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.overloads.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/MethodOverloadsParentMethodInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOverloadsParentMethodVisitor();
    }

    private static class MethodOverloadsParentMethodVisitor
    extends BaseInspectionVisitor {
        private MethodOverloadsParentMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/visibility/MethodOverloadsParentMethodInspection$MethodOverloadsParentMethodVisitor.visitMethod must not be null");
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (method.hasModifierProperty("private") || method.hasModifierProperty("static")) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (method.isConstructor()) {
                return;
            }
            Query superMethodQuery = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false);
            if (superMethodQuery.findFirst() != null) {
                return;
            }
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            for (PsiClass ancestorClass = aClass.getSuperClass(); ancestorClass != null; ancestorClass = ancestorClass.getSuperClass()) {
                if (!visitedClasses.add(ancestorClass)) {
                    return;
                }
                if (!MethodOverloadsParentMethodVisitor.methodOverloads(method, ancestorClass)) continue;
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }

        private static boolean methodOverloads(PsiMethod method, PsiClass ancestorClass) {
            PsiMethod[] methods;
            if (MethodOverloadsParentMethodVisitor.methodOverrides(method, ancestorClass)) {
                return false;
            }
            String methName = method.getName();
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            for (PsiMethod testMethod : methods = ancestorClass.findMethodsByName(methName, false)) {
                PsiParameterList testParameterList;
                PsiParameter[] testParameters;
                if (testMethod.hasModifierProperty("private") || testMethod.hasModifierProperty("static") || MethodOverloadsParentMethodVisitor.isOverriddenInClass(testMethod, method.getContainingClass()) || (testParameters = (testParameterList = testMethod.getParameterList()).getParameters()).length != parameters.length || MethodOverloadsParentMethodVisitor.parametersAreCompatible(parameters, testParameters)) continue;
                return true;
            }
            return false;
        }

        private static boolean isOverriddenInClass(PsiMethod method, PsiClass aClass) {
            PsiMethod[] methods;
            for (PsiMethod testMethod : methods = aClass.getMethods()) {
                PsiMethod[] superMethods;
                String testMethodName = testMethod.getName();
                if (!testMethodName.equals(method.getName())) continue;
                for (PsiMethod superMethod : superMethods = testMethod.findSuperMethods(true)) {
                    if (!superMethod.equals(method)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean parametersAreCompatible(PsiParameter[] parameters, PsiParameter[] testParameters) {
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter testParameter;
                PsiType testParameterType;
                PsiParameter parameter = parameters[i];
                PsiType parameterType = parameter.getType();
                if (parameterType.isAssignableFrom(testParameterType = (testParameter = testParameters[i]).getType())) continue;
                return false;
            }
            return true;
        }

        private static boolean methodOverrides(PsiMethod meth, PsiClass ancestorClass) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = meth.findSuperMethods(true)) {
                if (!ancestorClass.equals(superMethod.getContainingClass())) continue;
                return true;
            }
            return false;
        }
    }
}

