/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SystemRunFinalizersOnExitInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("CallToSystemRunFinalizersOnExit" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SystemRunFinalizersOnExitInspection.getID must not return null");
        }
        return "CallToSystemRunFinalizersOnExit";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("system.run.finalizers.on.exit.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SystemRunFinalizersOnExitInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("system.run.finalizers.on.exit.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SystemRunFinalizersOnExitInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SystemRunFinalizersOnExitVisitor();
    }

    private static class SystemRunFinalizersOnExitVisitor
    extends BaseInspectionVisitor {
        private SystemRunFinalizersOnExitVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/SystemRunFinalizersOnExitInspection$SystemRunFinalizersOnExitVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!SystemRunFinalizersOnExitVisitor.isRunFinalizersOnExit(expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean isRunFinalizersOnExit(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String runFinalizers = "runFinalizersOnExit";
            if (!"runFinalizersOnExit".equals(methodName)) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            if (className == null) {
                return false;
            }
            return "java.lang.System".equals(className);
        }
    }
}

