/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SafeLockInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("LockAcquiredButNotSafelyReleased" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SafeLockInspection.getID must not return null");
        }
        return "LockAcquiredButNotSafelyReleased";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("safe.lock.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SafeLockInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        PsiType type = expression.getType();
        assert (type != null);
        String text = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("safe.lock.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SafeLockInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SafeLockVisitor();
    }

    private static class UnlockVisitor
    extends JavaRecursiveElementVisitor {
        private boolean containsClose = false;
        private final PsiVariable objectToClose;

        private UnlockVisitor(PsiVariable objectToClose) {
            this.objectToClose = objectToClose;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/SafeLockInspection$UnlockVisitor.visitElement must not be null");
            }
            if (!this.containsClose) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/SafeLockInspection$UnlockVisitor.visitMethodCallExpression must not be null");
            }
            if (this.containsClose) {
                return;
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"unlock".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (referent == null) {
                return;
            }
            if (referent.equals(this.objectToClose)) {
                this.containsClose = true;
            }
        }

        public boolean containsStreamClose() {
            return this.containsClose;
        }
    }

    private static class SafeLockVisitor
    extends BaseInspectionVisitor {
        private SafeLockVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/SafeLockInspection$SafeLockVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!SafeLockVisitor.isLockAcquireMethod(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression lhs = methodExpression.getQualifierExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement referent = referenceExpression.resolve();
            if (referent == null || !(referent instanceof PsiVariable)) {
                return;
            }
            PsiVariable boundVariable = (PsiVariable)referent;
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class);
            if (statement == null) {
                return;
            }
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
            if (!(nextStatement instanceof PsiTryStatement)) {
                this.registerError((PsiElement)expression, referenceExpression);
                return;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)nextStatement;
            if (SafeLockVisitor.lockIsUnlockedInFinally(tryStatement, boundVariable)) {
                return;
            }
            this.registerError((PsiElement)expression, referenceExpression);
        }

        private static boolean lockIsUnlockedInFinally(PsiTryStatement tryStatement, PsiVariable boundVariable) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return false;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return false;
            }
            UnlockVisitor visitor = new UnlockVisitor(boundVariable);
            finallyBlock.accept((PsiElementVisitor)visitor);
            return visitor.containsStreamClose();
        }

        private static boolean isLockAcquireMethod(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"lock".equals(methodName) && !"lockInterruptibly".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            return TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.concurrent.locks.Lock");
        }
    }
}

