/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class ObjectNotifyInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("CallToNotifyInsteadOfNotifyAll" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ObjectNotifyInspection.getID must not return null");
        }
        return "CallToNotifyInsteadOfNotifyAll";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("object.notify.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ObjectNotifyInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("object.notify.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ObjectNotifyInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectNotifyVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ObjectNotifyFix();
    }

    private static class ObjectNotifyVisitor
    extends BaseInspectionVisitor {
        private ObjectNotifyVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/ObjectNotifyInspection$ObjectNotifyVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"notify".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList.getExpressions().length != 0) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }

    private static class ObjectNotifyFix
    extends InspectionGadgetsFix {
        private ObjectNotifyFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("object.notify.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ObjectNotifyInspection$ObjectNotifyFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameElement = descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)methodNameElement.getParent();
            assert (methodExpression != null);
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                ObjectNotifyFix.replaceExpression((PsiExpression)methodExpression, "notifyAll");
            } else {
                String qualifierText = qualifier.getText();
                ObjectNotifyFix.replaceExpression((PsiExpression)methodExpression, qualifierText + '.' + "notifyAll");
            }
        }
    }
}

