/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryQualifierForThisInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryQualifierForThisInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryQualifierForThisInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryQualifierForThisVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryQualifierForThisFix();
    }

    private static class UnnecessaryQualifierForThisVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryQualifierForThisVisitor() {
        }

        public void visitThisExpression(@NotNull PsiThisExpression thisExpression) {
            if (thisExpression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/UnnecessaryQualifierForThisInspection$UnnecessaryQualifierForThisVisitor.visitThisExpression must not be null");
            }
            super.visitThisExpression(thisExpression);
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement referent = qualifier.resolve();
            if (!(referent instanceof PsiClass)) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)thisExpression);
            if (containingClass == null) {
                return;
            }
            if (!containingClass.equals(referent)) {
                return;
            }
            this.registerError((PsiElement)qualifier, new Object[0]);
        }
    }

    private static class UnnecessaryQualifierForThisFix
    extends InspectionGadgetsFix {
        private UnnecessaryQualifierForThisFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryQualifierForThisInspection$UnnecessaryQualifierForThisFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement qualifier = descriptor.getPsiElement();
            PsiThisExpression thisExpression = (PsiThisExpression)qualifier.getParent();
            UnnecessaryQualifierForThisFix.replaceExpression((PsiExpression)thisExpression, "this");
        }
    }
}

