/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryFinalOnParameterInspection
extends BaseInspection {
    public boolean onlyWarnOnAbstractMethods = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.final.on.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryFinalOnParameterInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("UnnecessaryFinalForMethodParameter" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryFinalOnParameterInspection.getID must not return null");
        }
        return "UnnecessaryFinalForMethodParameter";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiParameter parameter = (PsiParameter)infos[0];
        String parameterName = parameter.getName();
        String string = InspectionGadgetsBundle.message("unnecessary.final.on.parameter.problem.descriptor", parameterName);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryFinalOnParameterInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.final.on.parameter.only.interface.option", new Object[0]), (InspectionProfileEntry)this, "onlyWarnOnAbstractMethods");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryFinalOnParameterVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveModifierFix((String)infos[1]);
    }

    private class UnnecessaryFinalOnParameterVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryFinalOnParameterVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiParameter[] parameters;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/UnnecessaryFinalOnParameterInspection$UnnecessaryFinalOnParameterVisitor.visitMethod must not be null");
            }
            super.visitMethod(method);
            PsiParameterList parameterList = method.getParameterList();
            for (PsiParameter parameter : parameters = parameterList.getParameters()) {
                this.checkParameter(method, parameter);
            }
        }

        private void checkParameter(PsiMethod method, PsiParameter parameter) {
            if (!parameter.hasModifierProperty("final")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && (containingClass.isInterface() || containingClass.isAnnotationType())) {
                this.registerModifierError("final", (PsiModifierListOwner)parameter, parameter, "final");
                return;
            }
            if (method.hasModifierProperty("abstract")) {
                this.registerModifierError("final", (PsiModifierListOwner)parameter, parameter, "final");
                return;
            }
            if (UnnecessaryFinalOnParameterInspection.this.onlyWarnOnAbstractMethods) {
                return;
            }
            if (VariableAccessUtils.variableIsUsedInInnerClass((PsiVariable)parameter, (PsiElement)method)) {
                return;
            }
            this.registerModifierError("final", (PsiModifierListOwner)parameter, parameter, "final");
        }
    }
}

