/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NestedMethodCallInspection
extends BaseInspection {
    public boolean m_ignoreFieldInitializations = true;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("nested.method.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/NestedMethodCallInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("nested.method.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/NestedMethodCallInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("nested.method.call.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreFieldInitializations");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedMethodCallVisitor();
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new NestedMethodCallFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private class NestedMethodCallVisitor
    extends BaseInspectionVisitor {
        private NestedMethodCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiElement field;
            PsiMethodCallExpression surroundingCall;
            PsiReferenceExpression methodExpression;
            String callName;
            PsiMethodCallExpression outerExpression;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/NestedMethodCallInspection$NestedMethodCallVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            for (outerExpression = expression; outerExpression != null && outerExpression.getParent() instanceof PsiExpression; outerExpression = (PsiExpression)outerExpression.getParent()) {
            }
            if (outerExpression == null) {
                return;
            }
            PsiElement parent = outerExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiCallExpression)) {
                return;
            }
            if (grandParent instanceof PsiMethodCallExpression && ("this".equals(callName = (methodExpression = (surroundingCall = (PsiMethodCallExpression)grandParent).getMethodExpression()).getReferenceName()) || "super".equals(callName))) {
                return;
            }
            if (NestedMethodCallInspection.this.m_ignoreFieldInitializations && (field = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiField.class)) != null) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }

    private static class NestedMethodCallFix
    extends InspectionGadgetsFix {
        private NestedMethodCallFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("introduce.variable.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/NestedMethodCallInspection$NestedMethodCallFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
            RefactoringActionHandler introduceHandler = factory.createIntroduceVariableHandler();
            PsiElement methodNameElement = descriptor.getPsiElement();
            PsiElement methodExpression = methodNameElement.getParent();
            if (methodExpression == null) {
                return;
            }
            PsiElement methodCallExpression = methodExpression.getParent();
            DataManager dataManager = DataManager.getInstance();
            DataContext dataContext = dataManager.getDataContext();
            introduceHandler.invoke(project, new PsiElement[]{methodCallExpression}, dataContext);
        }
    }
}

