/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeSerializableFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class NonSerializableWithSerialVersionUIDFieldInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("NonSerializableClassWithSerialVersionUID" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection.getID must not return null");
        }
        return "NonSerializableClassWithSerialVersionUID";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.serializable.with.serialversionuid.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass.isAnnotationType()) {
            string = InspectionGadgetsBundle.message("non.serializable.@interface.with.serialversionuid.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection.buildErrorString must not return null");
            return string;
        }
        if (aClass.isInterface()) {
            string = InspectionGadgetsBundle.message("non.serializable.interface.with.serialversionuid.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection.buildErrorString must not return null");
            return string;
        }
        if (aClass instanceof PsiAnonymousClass) {
            string = InspectionGadgetsBundle.message("non.serializable.anonymous.with.serialversionuid.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("non.serializable.class.with.serialversionuid.problem.descriptor", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection.buildErrorString must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray;
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass.isAnnotationType() || aClass.isInterface() || aClass instanceof PsiAnonymousClass) {
            inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new RemoveSerialVersionUIDFix()};
            if (inspectionGadgetsFixArray == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection.buildFixes must not return null");
            return inspectionGadgetsFixArray;
        }
        inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new MakeSerializableFix(), new RemoveSerialVersionUIDFix()};
        if (inspectionGadgetsFixArray != null) return inspectionGadgetsFixArray;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection.buildFixes must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonSerializableWithSerialVersionUIDVisitor();
    }

    private static class NonSerializableWithSerialVersionUIDVisitor
    extends BaseInspectionVisitor {
        private NonSerializableWithSerialVersionUIDVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection$NonSerializableWithSerialVersionUIDVisitor.visitClass must not be null");
            }
            PsiField field = aClass.findFieldByName("serialVersionUID", false);
            if (field == null) {
                return;
            }
            if (SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }

    private static class RemoveSerialVersionUIDFix
    extends InspectionGadgetsFix {
        private RemoveSerialVersionUIDFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("non.serializable.with.serialversionuid.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableWithSerialVersionUIDFieldInspection$RemoveSerialVersionUIDFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement nameElement = descriptor.getPsiElement();
            PsiClass aClass = (PsiClass)nameElement.getParent();
            PsiField field = aClass.findFieldByName("serialVersionUID", false);
            if (field == null) {
                return;
            }
            field.delete();
        }
    }
}

