/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeUtils {
    private TypeUtils() {
    }

    public static boolean expressionHasType(@NonNls @NotNull String typeName, @Nullable PsiExpression expression) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/TypeUtils.expressionHasType must not be null");
        }
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        return TypeUtils.typeEquals(typeName, type);
    }

    public static boolean typeEquals(@NonNls @NotNull String typeName, @Nullable PsiType targetType) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/TypeUtils.typeEquals must not be null");
        }
        return targetType != null && targetType.equalsToText(typeName);
    }

    public static PsiType getJavaLangObjectType(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/TypeUtils.getJavaLangObjectType must not be null");
        }
        Project project = context.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        return factory.createTypeFromText("java.lang.Object", context);
    }

    public static boolean isJavaLangObject(@Nullable PsiType targetType) {
        return TypeUtils.typeEquals("java.lang.Object", targetType);
    }

    public static boolean isJavaLangString(@Nullable PsiType targetType) {
        return TypeUtils.typeEquals("java.lang.String", targetType);
    }

    public static boolean expressionHasTypeOrSubtype(@Nullable PsiExpression expression, @NonNls @NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/TypeUtils.expressionHasTypeOrSubtype must not be null");
        }
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        return aClass != null && ClassUtils.isSubclass(aClass, typeName);
    }

    public static String expressionHasTypeOrSubtype(@Nullable PsiExpression expression, String ... typeNames) {
        if (typeNames == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/TypeUtils.expressionHasTypeOrSubtype must not be null");
        }
        if (expression == null) {
            return null;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return null;
        }
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return null;
        }
        for (String typeName : typeNames) {
            if (!ClassUtils.isSubclass(aClass, typeName)) continue;
            return typeName;
        }
        return null;
    }

    public static boolean expressionHasTypeOrSubtype(@Nullable PsiExpression expression, @NonNls @NotNull Collection<String> typeNames) {
        if (typeNames == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/TypeUtils.expressionHasTypeOrSubtype must not be null");
        }
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return false;
        }
        for (String typeName : typeNames) {
            if (!ClassUtils.isSubclass(aClass, typeName)) continue;
            return true;
        }
        return false;
    }
}

