/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class SideEffectChecker {
    private SideEffectChecker() {
    }

    public static boolean mayHaveSideEffects(@NotNull PsiExpression exp) {
        if (exp == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SideEffectChecker.mayHaveSideEffects must not be null");
        }
        SideEffectsVisitor visitor = new SideEffectsVisitor();
        exp.accept((PsiElementVisitor)visitor);
        return visitor.mayHaveSideEffects();
    }

    private static class SideEffectsVisitor
    extends JavaRecursiveElementVisitor {
        private boolean mayHaveSideEffects = false;

        private SideEffectsVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor.visitElement must not be null");
            }
            if (!this.mayHaveSideEffects) {
                super.visitElement(element);
            }
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor.visitAssignmentExpression must not be null");
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitAssignmentExpression(expression);
            this.mayHaveSideEffects = true;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor.visitMethodCallExpression must not be null");
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitMethodCallExpression(expression);
            this.mayHaveSideEffects = true;
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor.visitNewExpression must not be null");
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitNewExpression(expression);
            this.mayHaveSideEffects = true;
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor.visitPostfixExpression must not be null");
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitPostfixExpression(expression);
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) {
                this.mayHaveSideEffects = true;
            }
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor.visitPrefixExpression must not be null");
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitPrefixExpression(expression);
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) {
                this.mayHaveSideEffects = true;
            }
        }

        public boolean mayHaveSideEffects() {
            return this.mayHaveSideEffects;
        }
    }
}

