/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Query;

public class InheritanceUtil {
    private InheritanceUtil() {
    }

    public static boolean existsMutualSubclass(PsiClass class1, PsiClass class2) {
        if (class1 instanceof PsiTypeParameter) {
            PsiClass[] superClasses;
            for (PsiClass superClass : superClasses = class1.getSupers()) {
                if (InheritanceUtil.existsMutualSubclass(superClass, class2)) continue;
                return false;
            }
            return true;
        }
        if (class2 instanceof PsiTypeParameter) {
            return InheritanceUtil.existsMutualSubclass(class2, class1);
        }
        String className = class1.getQualifiedName();
        if ("java.lang.Object".equals(className)) {
            return true;
        }
        String class2Name = class2.getQualifiedName();
        if ("java.lang.Object".equals(class2Name)) {
            return true;
        }
        if (class1.isInheritor(class2, true) || class2.isInheritor(class1, true)) {
            return true;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)class1.getProject());
        Query search = ClassInheritorsSearch.search((PsiClass)class1, (SearchScope)scope, (boolean)true, (boolean)true);
        for (PsiClass inheritor : search) {
            if (!inheritor.equals(class2) && !inheritor.isInheritor(class2, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasImplementation(PsiClass aClass) {
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)aClass.getProject());
        Query search = ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)scope, (boolean)true, (boolean)true);
        for (PsiClass inheritor : search) {
            if (inheritor.isInterface() || inheritor.isAnnotationType() || inheritor.hasModifierProperty("abstract")) continue;
            return true;
        }
        return false;
    }
}

