/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtils {
    private static final Set<String> s_genericExceptionTypes = new HashSet<String>(4);

    private ExceptionUtils() {
    }

    @NotNull
    public static Set<PsiType> calculateExceptionsThrown(@NotNull PsiElement statement) {
        if (statement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExceptionUtils.calculateExceptionsThrown must not be null");
        }
        ExceptionsThrownVisitor visitor = new ExceptionsThrownVisitor();
        statement.accept((PsiElementVisitor)visitor);
        Set<PsiType> set = visitor.getExceptionsThrown();
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/ExceptionUtils.calculateExceptionsThrown must not return null");
        }
        return set;
    }

    public static boolean isGenericExceptionClass(@Nullable PsiType exceptionType) {
        if (!(exceptionType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)exceptionType;
        String className = classType.getCanonicalText();
        return s_genericExceptionTypes.contains(className);
    }

    public static boolean statementThrowsException(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiAssertStatement || statement instanceof PsiReturnStatement || statement instanceof PsiExpressionStatement || statement instanceof PsiExpressionListStatement || statement instanceof PsiForeachStatement || statement instanceof PsiDeclarationStatement || statement instanceof PsiEmptyStatement) {
            return false;
        }
        if (statement instanceof PsiThrowStatement) {
            return true;
        }
        if (statement instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)statement;
            return ExceptionUtils.forStatementThrowsException(forStatement);
        }
        if (statement instanceof PsiWhileStatement) {
            return ExceptionUtils.whileStatementThrowsException((PsiWhileStatement)statement);
        }
        if (statement instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement;
            return ExceptionUtils.doWhileThrowsException(doWhileStatement);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement;
            PsiCodeBlock body = synchronizedStatement.getBody();
            return ExceptionUtils.blockThrowsException(body);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            return ExceptionUtils.blockThrowsException(codeBlock);
        }
        if (statement instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
            PsiStatement statementLabeled = labeledStatement.getStatement();
            return ExceptionUtils.statementThrowsException(statementLabeled);
        }
        if (statement instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            return ExceptionUtils.ifStatementThrowsException(ifStatement);
        }
        if (statement instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement;
            return ExceptionUtils.tryStatementThrowsException(tryStatement);
        }
        if (statement instanceof PsiSwitchStatement) {
            return false;
        }
        return false;
    }

    public static boolean blockThrowsException(@Nullable PsiCodeBlock block) {
        PsiStatement[] statements;
        if (block == null) {
            return false;
        }
        for (PsiStatement statement : statements = block.getStatements()) {
            if (!ExceptionUtils.statementThrowsException(statement)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryStatementThrowsException(PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
        if (catchBlocks.length == 0 && ExceptionUtils.blockThrowsException(tryBlock = tryStatement.getTryBlock())) {
            return true;
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        return ExceptionUtils.blockThrowsException(finallyBlock);
    }

    private static boolean ifStatementThrowsException(PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        return ExceptionUtils.statementThrowsException(thenBranch) && ExceptionUtils.statementThrowsException(elseBranch);
    }

    private static boolean doWhileThrowsException(PsiDoWhileStatement doWhileStatement) {
        PsiStatement body = doWhileStatement.getBody();
        return ExceptionUtils.statementThrowsException(body);
    }

    private static boolean whileStatementThrowsException(PsiWhileStatement whileStatement) {
        PsiStatement body;
        PsiExpression condition = whileStatement.getCondition();
        return BoolUtils.isTrue(condition) && ExceptionUtils.statementThrowsException(body = whileStatement.getBody());
    }

    private static boolean forStatementThrowsException(PsiForStatement forStatement) {
        PsiStatement initialization = forStatement.getInitialization();
        if (ExceptionUtils.statementThrowsException(initialization)) {
            return true;
        }
        PsiExpression test = forStatement.getCondition();
        if (BoolUtils.isTrue(test)) {
            PsiStatement body = forStatement.getBody();
            if (ExceptionUtils.statementThrowsException(body)) {
                return true;
            }
            PsiStatement update = forStatement.getUpdate();
            if (ExceptionUtils.statementThrowsException(update)) {
                return true;
            }
        }
        return false;
    }

    static {
        s_genericExceptionTypes.add("java.lang.Throwable");
        s_genericExceptionTypes.add("java.lang.Exception");
        s_genericExceptionTypes.add("java.lang.RuntimeException");
        s_genericExceptionTypes.add("java.lang.Error");
    }

    private static class ExceptionsThrownVisitor
    extends JavaRecursiveElementVisitor {
        private final Set<PsiType> m_exceptionsThrown = new HashSet<PsiType>(4);

        private ExceptionsThrownVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiJavaCodeReferenceElement[] list;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExceptionUtils$ExceptionsThrownVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiReferenceList throwsList = method.getThrowsList();
            PsiManager psiManager = expression.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            for (PsiJavaCodeReferenceElement referenceElement : list = throwsList.getReferenceElements()) {
                PsiClass exceptionClass = (PsiClass)referenceElement.resolve();
                if (exceptionClass == null) continue;
                PsiClassType exceptionType = factory.createType(exceptionClass);
                this.m_exceptionsThrown.add((PsiType)exceptionType);
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiJavaCodeReferenceElement[] list;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExceptionUtils$ExceptionsThrownVisitor.visitNewExpression must not be null");
            }
            super.visitNewExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiReferenceList throwsList = method.getThrowsList();
            PsiManager psiManager = expression.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            for (PsiJavaCodeReferenceElement referenceElement : list = throwsList.getReferenceElements()) {
                PsiClass exceptionClass = (PsiClass)referenceElement.resolve();
                if (exceptionClass == null) continue;
                PsiClassType exceptionType = factory.createType(exceptionClass);
                this.m_exceptionsThrown.add((PsiType)exceptionType);
            }
        }

        public void visitThrowStatement(PsiThrowStatement statement) {
            super.visitThrowStatement(statement);
            PsiExpression exception = statement.getException();
            if (exception == null) {
                return;
            }
            PsiType type = exception.getType();
            if (type == null) {
                return;
            }
            this.m_exceptionsThrown.add(type);
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiCodeBlock[] catchBlocks;
            PsiCodeBlock finallyBlock;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExceptionUtils$ExceptionsThrownVisitor.visitTryStatement must not be null");
            }
            PsiCodeBlock tryBlock = statement.getTryBlock();
            Set<PsiType> exceptionsThrown = this.m_exceptionsThrown;
            if (tryBlock != null) {
                Set<PsiType> tryExceptions = ExceptionUtils.calculateExceptionsThrown((PsiElement)tryBlock);
                Set<PsiType> exceptionsHandled = ExceptionsThrownVisitor.getExceptionTypesHandled(statement);
                for (PsiType tryException : tryExceptions) {
                    PsiType thrownType = tryException;
                    if (ExceptionsThrownVisitor.isExceptionHandled(exceptionsHandled, thrownType)) continue;
                    exceptionsThrown.add(thrownType);
                }
            }
            if ((finallyBlock = statement.getFinallyBlock()) != null) {
                Set<PsiType> finallyExceptions = ExceptionUtils.calculateExceptionsThrown((PsiElement)finallyBlock);
                exceptionsThrown.addAll(finallyExceptions);
            }
            for (PsiCodeBlock catchBlock : catchBlocks = statement.getCatchBlocks()) {
                Set<PsiType> catchExceptions = ExceptionUtils.calculateExceptionsThrown((PsiElement)catchBlock);
                exceptionsThrown.addAll(catchExceptions);
            }
        }

        private static boolean isExceptionHandled(Set<PsiType> exceptionHandled, PsiType thrownType) {
            for (PsiType aExceptionHandled : exceptionHandled) {
                PsiType handledType = aExceptionHandled;
                if (!handledType.isAssignableFrom(thrownType)) continue;
                return true;
            }
            return false;
        }

        private static Set<PsiType> getExceptionTypesHandled(@NotNull PsiTryStatement statement) {
            PsiParameter[] params;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ExceptionUtils$ExceptionsThrownVisitor.getExceptionTypesHandled must not be null");
            }
            HashSet<PsiType> out = new HashSet<PsiType>(5);
            for (PsiParameter param : params = statement.getCatchBlockParameters()) {
                PsiType type = param.getType();
                out.add(type);
            }
            return out;
        }

        @NotNull
        public Set<PsiType> getExceptionsThrown() {
            Set<PsiType> set = Collections.unmodifiableSet(this.m_exceptionsThrown);
            if (set == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/psiutils/ExceptionUtils$ExceptionsThrownVisitor.getExceptionsThrown must not return null");
            }
            return set;
        }
    }
}

