/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConstructorInspection
extends BaseInspection {
    public boolean ignoreSubstringArguments = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringConstructorInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("RedundantStringConstructorCall" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringConstructorInspection.getID must not return null");
        }
        return "RedundantStringConstructorCall";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringConstructorInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("string.constructor.substring.parameter.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSubstringArguments");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConstructorVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        Boolean noArguments = (Boolean)infos[0];
        return new StringConstructorFix(noArguments);
    }

    private class StringConstructorVisitor
    extends BaseInspectionVisitor {
        private StringConstructorVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/StringConstructorInspection$StringConstructorVisitor.visitNewExpression must not be null");
            }
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length > 1) {
                return;
            }
            if (arguments.length == 1) {
                PsiMethodCallExpression methodCallExpression;
                PsiReferenceExpression methodExpression;
                PsiElement element;
                PsiExpression argument = arguments[0];
                PsiType parameterType = argument.getType();
                if (!TypeUtils.isJavaLangString(parameterType)) {
                    return;
                }
                if (StringConstructorInspection.this.ignoreSubstringArguments && argument instanceof PsiMethodCallExpression && (element = (methodExpression = (methodCallExpression = (PsiMethodCallExpression)argument).getMethodExpression()).resolve()) instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)element;
                    PsiClass aClass = method.getContainingClass();
                    String className = aClass.getQualifiedName();
                    String methodName = method.getName();
                    if ("java.lang.String".equals(className) && methodName.equals("substring")) {
                        return;
                    }
                }
            }
            this.registerError((PsiElement)expression, arguments.length == 0);
        }
    }

    private static class StringConstructorFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private StringConstructorFix(boolean noArguments) {
            this.m_name = noArguments ? InspectionGadgetsBundle.message("string.constructor.replace.empty.quickfix", new Object[0]) : InspectionGadgetsBundle.message("string.constructor.replace.arg.quickfix", new Object[0]);
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringConstructorInspection$StringConstructorFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiNewExpression expression = (PsiNewExpression)descriptor.getPsiElement();
            PsiExpressionList argList = expression.getArgumentList();
            assert (argList != null);
            PsiExpression[] args = argList.getExpressions();
            String argText = args.length == 1 ? args[0].getText() : "\"\"";
            StringConstructorFix.replaceExpression((PsiExpression)expression, argText);
        }
    }
}

