/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class StringBufferToStringInConcatenationInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.buffer.to.string.in.concatenation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringBufferToStringInConcatenationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.buffer.to.string.in.concatenation.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringBufferToStringInConcatenationInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferToStringVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new StringBufferToStringFix();
    }

    private static class StringBufferToStringVisitor
    extends BaseInspectionVisitor {
        private StringBufferToStringVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiExpression lhs;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/StringBufferToStringInConcatenationInspection$StringBufferToStringVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression parentBinary = (PsiBinaryExpression)parent;
            PsiJavaToken sign = parentBinary.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUS)) {
                return;
            }
            PsiExpression rhs = parentBinary.getROperand();
            if (rhs == null) {
                return;
            }
            if (rhs.equals(expression) ? !TypeUtils.expressionHasType("java.lang.String", lhs = parentBinary.getLOperand()) : !TypeUtils.expressionHasType("java.lang.String", rhs)) {
                return;
            }
            if (!StringBufferToStringVisitor.isStringBufferToString(expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean isStringBufferToString(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"toString".equals(referenceName)) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            return "java.lang.StringBuffer".equals(className) || "java.lang.StringBuilder".equals(className);
        }
    }

    private static class StringBufferToStringFix
    extends InspectionGadgetsFix {
        private StringBufferToStringFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.buffer.to.string.in.concatenation.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringBufferToStringInConcatenationInspection$StringBufferToStringFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameToken = descriptor.getPsiElement();
            PsiElement methodCallExpression = methodNameToken.getParent();
            assert (methodCallExpression != null);
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)methodCallExpression.getParent();
            assert (methodCall != null);
            PsiReferenceExpression expression = methodCall.getMethodExpression();
            PsiExpression qualifier = expression.getQualifierExpression();
            assert (qualifier != null);
            String newExpression = qualifier.getText();
            StringBufferToStringFix.replaceExpression((PsiExpression)methodCall, newExpression);
        }
    }
}

