/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualArrayToCollectionCopyInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("manual.array.to.collection.copy.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/ManualArrayToCollectionCopyInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("manual.array.to.collection.copy.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/ManualArrayToCollectionCopyInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ManualArrayToCollectionCopyFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ManualArrayToCollectionCopyVisitor();
    }

    private static class ManualArrayToCollectionCopyVisitor
    extends BaseInspectionVisitor {
        private ManualArrayToCollectionCopyVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/ManualArrayToCollectionCopyInspection$ManualArrayToCollectionCopyVisitor.visitForStatement must not be null");
            }
            super.visitForStatement(statement);
            PsiStatement initialization = statement.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            PsiExpression initialValue = variable.getInitializer();
            if (initialValue == null) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            if (!ExpressionUtils.isComparison(condition, variable)) {
                return;
            }
            PsiStatement update = statement.getUpdate();
            if (!VariableAccessUtils.variableIsIncremented((PsiVariable)variable, update)) {
                return;
            }
            PsiStatement body = statement.getBody();
            if (!ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(body, (PsiVariable)variable, true)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            super.visitForeachStatement(statement);
            PsiExpression iteratedValue = statement.getIteratedValue();
            if (iteratedValue == null) {
                return;
            }
            PsiType type = iteratedValue.getType();
            if (!(type instanceof PsiArrayType)) {
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)type;
            PsiType componentType = arrayType.getComponentType();
            if (componentType instanceof PsiPrimitiveType) {
                return;
            }
            PsiParameter parameter = statement.getIterationParameter();
            PsiStatement body = statement.getBody();
            if (!ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(body, (PsiVariable)parameter, false)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        private static boolean bodyIsArrayToCollectionCopy(PsiStatement body, PsiVariable variable, boolean shouldBeOffsetArrayAccess) {
            if (body instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
                PsiExpression expression = expressionStatement.getExpression();
                return ManualArrayToCollectionCopyVisitor.expressionIsArrayToCollectionCopy(expression, variable, shouldBeOffsetArrayAccess);
            }
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                return statements.length == 1 && ManualArrayToCollectionCopyVisitor.bodyIsArrayToCollectionCopy(statements[0], variable, shouldBeOffsetArrayAccess);
            }
            return false;
        }

        private static boolean expressionIsArrayToCollectionCopy(PsiExpression expression, PsiVariable variable, boolean shouldBeOffsetArrayAccess) {
            if ((expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression)) == null) {
                return false;
            }
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression)) {
                return false;
            }
            PsiExpression argument = arguments[0];
            if (SideEffectChecker.mayHaveSideEffects(argument)) {
                return false;
            }
            if (shouldBeOffsetArrayAccess ? !ExpressionUtils.isOffsetArrayAccess(argument, variable) : !VariableAccessUtils.evaluatesToVariable(argument, variable)) {
                return false;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            String name = method.getName();
            if (!name.equals("add")) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            return ClassUtils.isSubclass(containingClass, "java.util.Collection");
        }
    }

    private static class ManualArrayToCollectionCopyFix
    extends InspectionGadgetsFix {
        private ManualArrayToCollectionCopyFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("manual.array.to.collection.copy.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/ManualArrayToCollectionCopyInspection$ManualArrayToCollectionCopyFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement forElement = descriptor.getPsiElement();
            PsiElement parent = forElement.getParent();
            if (parent instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)parent;
                String newExpression = ManualArrayToCollectionCopyFix.getCollectionsAddAllText(forStatement);
                if (newExpression == null) {
                    return;
                }
                ManualArrayToCollectionCopyFix.replaceStatementAndShortenClassNames((PsiStatement)forStatement, newExpression);
            } else {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)parent;
                String newExpression = ManualArrayToCollectionCopyFix.getCollectionsAddAllText(foreachStatement);
                if (newExpression == null) {
                    return;
                }
                ManualArrayToCollectionCopyFix.replaceStatementAndShortenClassNames((PsiStatement)foreachStatement, newExpression);
            }
        }

        @Nullable
        private static String getCollectionsAddAllText(PsiForeachStatement forStatement) throws IncorrectOperationException {
            PsiExpressionStatement body = ManualArrayToCollectionCopyFix.getBody((PsiLoopStatement)forStatement);
            if (body == null) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)body.getExpression();
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiElement collection = methodExpression.getQualifier();
            if (collection == null) {
                return null;
            }
            String collectionText = collection.getText();
            PsiExpression iteratedValue = forStatement.getIteratedValue();
            if (iteratedValue == null) {
                return null;
            }
            String arrayText = iteratedValue.getText();
            StringBuilder buffer = new StringBuilder(60);
            buffer.append(collectionText);
            buffer.append(".addAll(java.util.Arrays.asList(");
            buffer.append(arrayText);
            buffer.append("));");
            return buffer.toString();
        }

        @Nullable
        private static String getCollectionsAddAllText(PsiForStatement forStatement) throws IncorrectOperationException {
            PsiExpression expression = forStatement.getCondition();
            PsiBinaryExpression condition = (PsiBinaryExpression)PsiUtil.deparenthesizeExpression((PsiExpression)expression);
            if (condition == null) {
                return null;
            }
            PsiStatement initialization = forStatement.getInitialization();
            if (initialization == null) {
                return null;
            }
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return null;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            PsiExpressionStatement body = ManualArrayToCollectionCopyFix.getBody((PsiLoopStatement)forStatement);
            if (body == null) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)body.getExpression();
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiElement collection = methodExpression.getQualifier();
            if (collection == null) {
                return null;
            }
            String collectionText = collection.getText();
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression argument = argumentList.getExpressions()[0];
            PsiExpression deparenthesizedArgument = PsiUtil.deparenthesizeExpression((PsiExpression)argument);
            if (!(deparenthesizedArgument instanceof PsiArrayAccessExpression)) {
                return null;
            }
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)deparenthesizedArgument;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            String arrayText = arrayExpression.getText();
            PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
            String fromOffsetText = ManualArrayToCollectionCopyFix.getStartOffsetText(indexExpression, variable);
            if (fromOffsetText == null) {
                return null;
            }
            PsiExpression limit = condition.getOperationTokenType() == JavaTokenType.LT ? condition.getROperand() : condition.getLOperand();
            if ((limit = PsiUtil.deparenthesizeExpression((PsiExpression)limit)) == null) {
                return null;
            }
            String toOffsetText = limit.getText();
            if (toOffsetText == null) {
                return null;
            }
            StringBuilder buffer = new StringBuilder(60);
            buffer.append(collectionText);
            buffer.append(".addAll(java.util.Arrays.asList(");
            buffer.append(arrayText);
            buffer.append(')');
            if (!fromOffsetText.equals("0") || !toOffsetText.equals(arrayText + ".length")) {
                buffer.append(".subList(");
                buffer.append(fromOffsetText);
                buffer.append(", ");
                buffer.append(toOffsetText);
                buffer.append(')');
            }
            buffer.append(");");
            return buffer.toString();
        }

        @Nullable
        private static String getStartOffsetText(PsiExpression expression, PsiLocalVariable variable) throws IncorrectOperationException {
            String variableName;
            if ((expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression)) == null) {
                return null;
            }
            String expressionText = expression.getText();
            if (expressionText.equals(variableName = variable.getName())) {
                PsiExpression initialValue = variable.getInitializer();
                if (initialValue == null) {
                    return null;
                }
                return initialValue.getText();
            }
            if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                String rhsText = ManualArrayToCollectionCopyFix.getStartOffsetText(rhs, variable);
                PsiJavaToken sign = binaryExpression.getOperationSign();
                IElementType tokenType = sign.getTokenType();
                if (ExpressionUtils.isZero(lhs)) {
                    if (tokenType.equals(JavaTokenType.MINUS)) {
                        return '-' + rhsText;
                    }
                    return rhsText;
                }
                String lhsText = ManualArrayToCollectionCopyFix.getStartOffsetText(lhs, variable);
                if (ExpressionUtils.isZero(rhs)) {
                    return lhsText;
                }
                return ManualArrayToCollectionCopyFix.collapseConstant(lhsText + sign.getText() + rhsText, (PsiElement)variable);
            }
            return ManualArrayToCollectionCopyFix.collapseConstant(expression.getText(), (PsiElement)variable);
        }

        private static String collapseConstant(String expressionText, PsiElement context) throws IncorrectOperationException {
            Project project = context.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiExpression fromOffsetExpression = factory.createExpressionFromText(expressionText, context);
            Object fromOffsetConstant = ExpressionUtils.computeConstantExpression(fromOffsetExpression);
            if (fromOffsetConstant != null) {
                return fromOffsetConstant.toString();
            }
            return expressionText;
        }

        @Nullable
        private static PsiExpressionStatement getBody(PsiLoopStatement forStatement) {
            PsiStatement body = forStatement.getBody();
            while (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                body = statements[0];
            }
            return (PsiExpressionStatement)body;
        }
    }
}

