/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualArrayCopyInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("manual.array.copy.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/ManualArrayCopyInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("manual.array.copy.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/ManualArrayCopyInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ManualArrayCopyVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ManualArrayCopyFix();
    }

    private static class ManualArrayCopyVisitor
    extends BaseInspectionVisitor {
        private ManualArrayCopyVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/ManualArrayCopyInspection$ManualArrayCopyVisitor.visitForStatement must not be null");
            }
            super.visitForStatement(statement);
            PsiStatement initialization = statement.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            PsiExpression initialValue = variable.getInitializer();
            if (initialValue == null) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            if (!ExpressionUtils.isComparison(condition, variable)) {
                return;
            }
            PsiStatement update = statement.getUpdate();
            if (!VariableAccessUtils.variableIsIncremented((PsiVariable)variable, update)) {
                return;
            }
            PsiStatement body = statement.getBody();
            if (!ManualArrayCopyVisitor.bodyIsArrayCopy(body, variable)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        private static boolean bodyIsArrayCopy(PsiStatement body, PsiLocalVariable variable) {
            if (body instanceof PsiExpressionStatement) {
                PsiExpressionStatement exp = (PsiExpressionStatement)body;
                PsiExpression expression = exp.getExpression();
                return ManualArrayCopyVisitor.expressionIsArrayCopy(expression, (PsiVariable)variable);
            }
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                return statements.length == 1 && ManualArrayCopyVisitor.bodyIsArrayCopy(statements[0], variable);
            }
            return false;
        }

        private static boolean expressionIsArrayCopy(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
            PsiExpression strippedRhs;
            PsiExpression strippedLhs;
            if (variable == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/performance/ManualArrayCopyInspection$ManualArrayCopyVisitor.expressionIsArrayCopy must not be null");
            }
            PsiExpression strippedExpression = PsiUtil.deparenthesizeExpression((PsiExpression)expression);
            if (strippedExpression == null) {
                return false;
            }
            if (!(strippedExpression instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)strippedExpression;
            PsiJavaToken sign = assignment.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.EQ)) {
                return false;
            }
            PsiExpression lhs = assignment.getLExpression();
            if (SideEffectChecker.mayHaveSideEffects(lhs)) {
                return false;
            }
            if (!ExpressionUtils.isOffsetArrayAccess(lhs, variable)) {
                return false;
            }
            PsiExpression rhs = assignment.getRExpression();
            if (rhs == null) {
                return false;
            }
            if (SideEffectChecker.mayHaveSideEffects(rhs)) {
                return false;
            }
            if (!ManualArrayCopyVisitor.areExpressionsCopyable(lhs, rhs)) {
                return false;
            }
            PsiType type = lhs.getType();
            if (type instanceof PsiPrimitiveType && !ManualArrayCopyVisitor.areExpressionsCopyable(strippedLhs = ParenthesesUtils.stripParentheses(lhs), strippedRhs = ParenthesesUtils.stripParentheses(rhs))) {
                return false;
            }
            return ExpressionUtils.isOffsetArrayAccess(rhs, variable);
        }

        private static boolean areExpressionsCopyable(@Nullable PsiExpression lhs, @Nullable PsiExpression rhs) {
            if (lhs == null || rhs == null) {
                return false;
            }
            PsiType lhsType = lhs.getType();
            if (lhsType == null) {
                return false;
            }
            PsiType rhsType = rhs.getType();
            if (rhsType == null) {
                return false;
            }
            return !(lhsType instanceof PsiPrimitiveType ? !lhsType.equals(rhsType) : !lhsType.isAssignableFrom(rhsType) || rhsType instanceof PsiPrimitiveType);
        }
    }

    private static class ManualArrayCopyFix
    extends InspectionGadgetsFix {
        private ManualArrayCopyFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("manual.array.copy.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/ManualArrayCopyInspection$ManualArrayCopyFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement forElement = descriptor.getPsiElement();
            PsiForStatement forStatement = (PsiForStatement)forElement.getParent();
            String newExpression = ManualArrayCopyFix.getSystemArrayCopyText(forStatement);
            if (newExpression == null) {
                return;
            }
            ManualArrayCopyFix.replaceStatement((PsiStatement)forStatement, newExpression);
        }

        @Nullable
        private static String getSystemArrayCopyText(PsiForStatement forStatement) throws IncorrectOperationException {
            PsiExpression condition = forStatement.getCondition();
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)PsiUtil.deparenthesizeExpression((PsiExpression)condition);
            if (binaryExpression == null) {
                return null;
            }
            PsiExpression limit = JavaTokenType.LT.equals(binaryExpression.getOperationTokenType()) ? binaryExpression.getROperand() : binaryExpression.getLOperand();
            if (limit == null) {
                return null;
            }
            PsiStatement initialization = forStatement.getInitialization();
            if (initialization == null) {
                return null;
            }
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return null;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            String lengthText = ManualArrayCopyFix.getLengthText(limit, (PsiVariable)variable);
            PsiExpressionStatement body = ManualArrayCopyFix.getBody(forStatement);
            if (body == null) {
                return null;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)body.getExpression();
            PsiExpression lExpression = assignment.getLExpression();
            PsiArrayAccessExpression lhs = (PsiArrayAccessExpression)PsiUtil.deparenthesizeExpression((PsiExpression)lExpression);
            if (lhs == null) {
                return null;
            }
            PsiExpression lArray = lhs.getArrayExpression();
            String toArrayText = lArray.getText();
            PsiExpression rExpression = assignment.getRExpression();
            PsiArrayAccessExpression rhs = (PsiArrayAccessExpression)PsiUtil.deparenthesizeExpression((PsiExpression)rExpression);
            if (rhs == null) {
                return null;
            }
            PsiExpression rArray = rhs.getArrayExpression();
            String fromArrayText = rArray.getText();
            PsiExpression rhsIndexExpression = rhs.getIndexExpression();
            PsiExpression strippedRhsIndexExpression = PsiUtil.deparenthesizeExpression((PsiExpression)rhsIndexExpression);
            String fromOffsetText = ManualArrayCopyFix.getOffsetText(strippedRhsIndexExpression, variable);
            PsiExpression lhsIndexExpression = lhs.getIndexExpression();
            PsiExpression strippedLhsIndexExpression = PsiUtil.deparenthesizeExpression((PsiExpression)lhsIndexExpression);
            String toOffsetText = ManualArrayCopyFix.getOffsetText(strippedLhsIndexExpression, variable);
            StringBuilder buffer = new StringBuilder(60);
            buffer.append("System.arraycopy(");
            buffer.append(fromArrayText);
            buffer.append(", ");
            buffer.append(fromOffsetText);
            buffer.append(", ");
            buffer.append(toArrayText);
            buffer.append(", ");
            buffer.append(toOffsetText);
            buffer.append(", ");
            buffer.append(lengthText);
            buffer.append(");");
            return buffer.toString();
        }

        @NonNls
        @Nullable
        private static String getLengthText(PsiExpression expression, PsiVariable variable) {
            if ((expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression)) == null) {
                return null;
            }
            PsiExpression initializer = variable.getInitializer();
            String expressionText = expression.getText();
            if (initializer == null) {
                return expressionText;
            }
            if (ExpressionUtils.isZero(initializer)) {
                return expressionText;
            }
            int precedence = ParenthesesUtils.getPrecedence(initializer);
            String initializerText = precedence >= 6 ? '(' + initializer.getText() + ')' : initializer.getText();
            return expressionText + '-' + initializerText;
        }

        @NonNls
        @Nullable
        private static String getOffsetText(PsiExpression expression, PsiLocalVariable variable) throws IncorrectOperationException {
            String variableName;
            if (expression == null) {
                return null;
            }
            String expressionText = expression.getText();
            if (expressionText.equals(variableName = variable.getName())) {
                PsiExpression initialValue = variable.getInitializer();
                if (initialValue == null) {
                    return null;
                }
                return initialValue.getText();
            }
            if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                PsiExpression lhs = binaryExpression.getLOperand();
                String lhsText = ManualArrayCopyFix.getOffsetText(lhs, variable);
                PsiExpression rhs = binaryExpression.getROperand();
                String rhsText = ManualArrayCopyFix.getOffsetText(rhs, variable);
                PsiJavaToken sign = binaryExpression.getOperationSign();
                IElementType tokenType = sign.getTokenType();
                if (lhsText == null || lhsText.equals("0")) {
                    if (tokenType.equals(JavaTokenType.MINUS)) {
                        return '-' + rhsText;
                    }
                    return rhsText;
                }
                if (rhsText == null || rhsText.equals("0")) {
                    return lhsText;
                }
                return ManualArrayCopyFix.collapseConstant(lhsText + sign.getText() + rhsText, (PsiElement)variable);
            }
            return ManualArrayCopyFix.collapseConstant(expression.getText(), (PsiElement)variable);
        }

        private static String collapseConstant(@NonNls String expressionText, PsiElement context) throws IncorrectOperationException {
            Project project = context.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiExpression fromOffsetExpression = factory.createExpressionFromText(expressionText, context);
            Object fromOffsetConstant = ExpressionUtils.computeConstantExpression(fromOffsetExpression);
            if (fromOffsetConstant != null) {
                return fromOffsetConstant.toString();
            }
            return expressionText;
        }

        @Nullable
        private static PsiExpressionStatement getBody(PsiForStatement forStatement) {
            PsiStatement body = forStatement.getBody();
            while (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                body = statements[0];
            }
            return (PsiExpressionStatement)body;
        }
    }
}

