/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageWithTooManyClassesInspection
extends BaseGlobalInspection {
    public int limit = 10;

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.PACKAGING_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/packaging/PackageWithTooManyClassesInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(RefEntity refEntity, AnalysisScope analysisScope, InspectionManager inspectionManager, GlobalInspectionContext globalInspectionContext) {
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        List children = refEntity.getChildren();
        if (children == null) {
            return null;
        }
        int numClasses = 0;
        for (RefEntity child : children) {
            if (!(child instanceof RefClass)) continue;
            ++numClasses;
        }
        if (numClasses <= this.limit) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("package.with.too.many.classes.problem.descriptor", refEntity.getQualifiedName(), numClasses, this.limit);
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("package.with.too.many.classes.max.option", new Object[0]), (InspectionProfileEntry)this, "limit");
    }
}

