/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IntegerMultiplicationImplicitCastToLongInspection
extends BaseInspection {
    private static final Set<String> s_typesToCheck = new HashSet<String>(10);

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/IntegerMultiplicationImplicitCastToLongInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/IntegerMultiplicationImplicitCastToLongInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IntegerMultiplicationImplicitlyCastToLongVisitor();
    }

    static {
        s_typesToCheck.add("int");
        s_typesToCheck.add("short");
        s_typesToCheck.add("byte");
        s_typesToCheck.add("char");
    }

    private static class IntegerMultiplicationImplicitlyCastToLongVisitor
    extends BaseInspectionVisitor {
        private IntegerMultiplicationImplicitlyCastToLongVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/numeric/IntegerMultiplicationImplicitCastToLongInspection$IntegerMultiplicationImplicitlyCastToLongVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.ASTERISK) && !tokenType.equals(JavaTokenType.LTLT)) {
                return;
            }
            PsiType type = expression.getType();
            if (!IntegerMultiplicationImplicitlyCastToLongVisitor.isNonLongInteger(type)) {
                return;
            }
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiType rhsType = rhs.getType();
            if (!IntegerMultiplicationImplicitlyCastToLongVisitor.isNonLongInteger(rhsType)) {
                return;
            }
            PsiExpression context = IntegerMultiplicationImplicitlyCastToLongVisitor.getContainingExpression((PsiExpression)expression);
            if (context == null) {
                return;
            }
            PsiType contextType = ExpectedTypeUtils.findExpectedType(context, true);
            if (contextType == null) {
                return;
            }
            if (!contextType.equals(PsiType.LONG)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static PsiExpression getContainingExpression(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiBinaryExpression || parent instanceof PsiParenthesizedExpression || parent instanceof PsiPrefixExpression || parent instanceof PsiConditionalExpression) {
                return IntegerMultiplicationImplicitlyCastToLongVisitor.getContainingExpression((PsiExpression)parent);
            }
            return expression;
        }

        private static boolean isNonLongInteger(PsiType type) {
            if (type == null) {
                return false;
            }
            String text = type.getCanonicalText();
            if (text == null) {
                return false;
            }
            return s_typesToCheck.contains(text);
        }
    }
}

