/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public class BadOddnessInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("bad.oddness.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/BadOddnessInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("bad.oddness.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/BadOddnessInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BadOddnessVisitor();
    }

    private static class BadOddnessVisitor
    extends BaseInspectionVisitor {
        private BadOddnessVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/numeric/BadOddnessInspection$BadOddnessVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            if (!ComparisonUtils.isEqualityComparison(expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiExpression rhs = expression.getROperand();
            if (BadOddnessVisitor.isModTwo(lhs) && BadOddnessVisitor.hasValue(rhs, 1)) {
                this.registerError((PsiElement)expression, expression);
            }
            if (BadOddnessVisitor.isModTwo(rhs) && BadOddnessVisitor.hasValue(lhs, 1)) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static boolean isModTwo(PsiExpression exp) {
            if (!(exp instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binary = (PsiBinaryExpression)exp;
            PsiJavaToken sign = binary.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!JavaTokenType.PERC.equals(tokenType)) {
                return false;
            }
            PsiExpression rhs = binary.getROperand();
            PsiExpression lhs = binary.getLOperand();
            if (rhs == null) {
                return false;
            }
            return BadOddnessVisitor.hasValue(rhs, 2) || BadOddnessVisitor.hasValue(lhs, 2);
        }

        private static boolean hasValue(PsiExpression expression, int testValue) {
            Integer value = (Integer)ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)PsiType.INT);
            return value != null && value == testValue;
        }
    }
}

