/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.naming.ConventionInspection;
import org.jetbrains.annotations.NotNull;

public class StaticMethodNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.method.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/StaticMethodNamingConventionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        String methodName = (String)infos[0];
        if (methodName.length() < this.getMinLength()) {
            string = InspectionGadgetsBundle.message("static.method.naming.convention.problem.descriptor.short", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/StaticMethodNamingConventionInspection.buildErrorString must not return null");
            return string;
        }
        if (methodName.length() > this.getMaxLength()) {
            string = InspectionGadgetsBundle.message("static.method.naming.convention.problem.descriptor.long", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/StaticMethodNamingConventionInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("static.method.naming.convention.problem.descriptor.regex.mismatch", this.getRegex());
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/StaticMethodNamingConventionInspection.buildErrorString must not return null");
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/StaticMethodNamingConventionInspection$NamingConventionsVisitor.visitMethod must not be null");
            }
            super.visitMethod(method);
            if (!method.hasModifierProperty("static")) {
                return;
            }
            String name = method.getName();
            if (StaticMethodNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerMethodError(method, name);
        }
    }
}

