/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.ui.DocumentAdapter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.RegExFormatter;
import com.siyeh.ig.RegExInputVerifier;
import com.siyeh.ig.ui.BlankFiller;
import com.siyeh.ig.ui.FormattedTextFieldMacFix;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.InternationalFormatter;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public abstract class ConventionInspection
extends BaseInspection {
    public String m_regex = this.getDefaultRegex();
    public int m_minLength = this.getDefaultMinLength();
    public int m_maxLength = this.getDefaultMaxLength();
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);
    private static final int REGEX_COLUMN_COUNT = 25;

    @NonNls
    protected abstract String getDefaultRegex();

    protected abstract int getDefaultMinLength();

    protected abstract int getDefaultMaxLength();

    protected String getRegex() {
        return this.m_regex;
    }

    protected int getMinLength() {
        return this.m_minLength;
    }

    protected int getMaxLength() {
        return this.m_maxLength;
    }

    protected boolean isValid(String name) {
        int length = name.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (length > this.m_maxLength) {
            return false;
        }
        if ("serialVersionUID".equals(name)) {
            return true;
        }
        Matcher matcher = this.m_regexPattern.matcher(name);
        return matcher.matches();
    }

    public void readSettings(Element element) throws InvalidDataException {
        super.readSettings(element);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    public Collection<? extends JComponent> createExtraOptions() {
        return Collections.EMPTY_LIST;
    }

    public final JComponent createOptionsPanel() {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        JLabel patternLabel = new JLabel(InspectionGadgetsBundle.message("convention.pattern.option", new Object[0]));
        patternLabel.setHorizontalAlignment(11);
        JLabel minLengthLabel = new JLabel(InspectionGadgetsBundle.message("convention.min.length.option", new Object[0]));
        minLengthLabel.setHorizontalAlignment(11);
        JLabel maxLengthLabel = new JLabel(InspectionGadgetsBundle.message("convention.max.length.option", new Object[0]));
        maxLengthLabel.setHorizontalAlignment(11);
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setParseIntegerOnly(true);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumIntegerDigits(2);
        InternationalFormatter formatter = new InternationalFormatter(numberFormat);
        formatter.setAllowsInvalid(false);
        formatter.setCommitsOnValidEdit(true);
        final JFormattedTextField minLengthField = new JFormattedTextField(formatter);
        Font panelFont = panel.getFont();
        minLengthField.setFont(panelFont);
        minLengthField.setValue(this.m_minLength);
        minLengthField.setColumns(2);
        FormattedTextFieldMacFix.apply(minLengthField);
        final JFormattedTextField maxLengthField = new JFormattedTextField(formatter);
        maxLengthField.setFont(panelFont);
        maxLengthField.setValue(this.m_maxLength);
        maxLengthField.setColumns(2);
        FormattedTextFieldMacFix.apply(maxLengthField);
        final JFormattedTextField regexField = new JFormattedTextField(new RegExFormatter());
        regexField.setFont(panelFont);
        regexField.setValue(this.m_regexPattern);
        regexField.setColumns(25);
        regexField.setInputVerifier(new RegExInputVerifier());
        regexField.setFocusLostBehavior(0);
        FormattedTextFieldMacFix.apply(regexField);
        DocumentAdapter listener = new DocumentAdapter(){

            public void textChanged(DocumentEvent evt) {
                try {
                    regexField.commitEdit();
                    minLengthField.commitEdit();
                    maxLengthField.commitEdit();
                    ConventionInspection.this.m_regexPattern = (Pattern)regexField.getValue();
                    ConventionInspection.this.m_regex = ConventionInspection.this.m_regexPattern.pattern();
                    ConventionInspection.this.m_minLength = ((Number)minLengthField.getValue()).intValue();
                    ConventionInspection.this.m_maxLength = ((Number)maxLengthField.getValue()).intValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        };
        Document regexDocument = regexField.getDocument();
        regexDocument.addDocumentListener((DocumentListener)listener);
        Document minLengthDocument = minLengthField.getDocument();
        minLengthDocument.addDocumentListener((DocumentListener)listener);
        Document maxLengthDocument = maxLengthField.getDocument();
        maxLengthDocument.addDocumentListener((DocumentListener)listener);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 13;
        panel.add((Component)patternLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.fill = 2;
        constraints.anchor = 17;
        panel.add((Component)regexField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.anchor = 13;
        panel.add((Component)minLengthLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.anchor = 17;
        panel.add((Component)minLengthField, constraints);
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.anchor = 13;
        panel.add((Component)maxLengthLabel, constraints);
        constraints.gridx = 3;
        constraints.gridy = 1;
        constraints.anchor = 17;
        panel.add((Component)maxLengthField, constraints);
        Collection<? extends JComponent> extraOptions = this.createExtraOptions();
        constraints.gridx = 0;
        constraints.gridwidth = 4;
        constraints.insets.top = 0;
        constraints.insets.bottom = 0;
        for (JComponent jComponent : extraOptions) {
            ++constraints.gridy;
            panel.add((Component)jComponent, constraints);
        }
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weighty = 1.0;
        panel.add((Component)new BlankFiller(), constraints);
        return panel;
    }
}

