/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class ClassNamePrefixedWithPackageNameInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.name.prefixed.with.package.name.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/ClassNamePrefixedWithPackageNameInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.name.prefixed.with.package.name.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/ClassNamePrefixedWithPackageNameInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNameBePrefixedWithPackageNameVisitor();
    }

    private static class ClassNameBePrefixedWithPackageNameVisitor
    extends BaseInspectionVisitor {
        private ClassNameBePrefixedWithPackageNameVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            String lowercasePackageName;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/ClassNamePrefixedWithPackageNameInspection$ClassNameBePrefixedWithPackageNameVisitor.visitClass must not be null");
            }
            String className = aClass.getName();
            if (className == null) {
                return;
            }
            PsiClass outerClass = ClassUtils.getOutermostContainingClass(aClass);
            String qualifiedName = outerClass.getQualifiedName();
            if (qualifiedName == null) {
                return;
            }
            if (className.equals(qualifiedName)) {
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(qualifiedName, ".");
            String currentPackageName = null;
            String lastPackageName = null;
            while (tokenizer.hasMoreTokens()) {
                lastPackageName = currentPackageName;
                currentPackageName = tokenizer.nextToken();
            }
            if (lastPackageName == null) {
                return;
            }
            String lowercaseClassName = className.toLowerCase();
            if (!lowercaseClassName.startsWith(lowercasePackageName = lastPackageName.toLowerCase())) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

