/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.NegationCountVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ThreeNegationsPerMethodInspection
extends BaseInspection {
    public boolean m_ignoreInEquals = true;

    @NotNull
    public String getID() {
        if ("MethodWithMoreThanThreeNegations" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/ThreeNegationsPerMethodInspection.getID must not return null");
        }
        return "MethodWithMoreThanThreeNegations";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("three.negations.per.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/ThreeNegationsPerMethodInspection.getDisplayName must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("three.negations.per.method.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreInEquals");
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer negationCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("three.negations.per.method.problem.descriptor", negationCount);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/ThreeNegationsPerMethodInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreeNegationsPerMethodVisitor();
    }

    private class ThreeNegationsPerMethodVisitor
    extends BaseInspectionVisitor {
        private ThreeNegationsPerMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/methodmetrics/ThreeNegationsPerMethodInspection$ThreeNegationsPerMethodVisitor.visitMethod must not be null");
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            NegationCountVisitor visitor = new NegationCountVisitor();
            method.accept((PsiElementVisitor)visitor);
            int negationCount = visitor.getCount();
            if (negationCount <= 3) {
                return;
            }
            if (ThreeNegationsPerMethodInspection.this.m_ignoreInEquals && MethodUtils.isEquals(method)) {
                return;
            }
            this.registerMethodError(method, negationCount);
        }
    }
}

