/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeParameterExtendsFinalClassInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("type.parameter.extends.final.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string;
        Integer problemType = (Integer)infos[1];
        PsiNamedElement namedElement = (PsiNamedElement)infos[0];
        String name = namedElement.getName();
        if (problemType == 1) {
            string = InspectionGadgetsBundle.message("type.parameter.extends.final.class.problem.descriptor1", name);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("type.parameter.extends.final.class.problem.descriptor2", name);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection.buildErrorString must not return null");
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new TypeParameterExtendsFinalClassFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TypeParameterExtendsFinalClassVisitor();
    }

    private static class TypeParameterExtendsFinalClassVisitor
    extends BaseInspectionVisitor {
        private TypeParameterExtendsFinalClassVisitor() {
        }

        public void visitTypeParameter(PsiTypeParameter classParameter) {
            super.visitTypeParameter(classParameter);
            PsiClassType[] extendsListTypes = classParameter.getExtendsListTypes();
            if (extendsListTypes.length < 1) {
                return;
            }
            PsiClassType extendsType = extendsListTypes[0];
            PsiClass aClass = extendsType.resolve();
            if (aClass == null) {
                return;
            }
            if (!aClass.hasModifierProperty("final")) {
                return;
            }
            PsiIdentifier nameIdentifier = classParameter.getNameIdentifier();
            if (nameIdentifier != null) {
                this.registerError((PsiElement)nameIdentifier, aClass, 1);
            }
        }

        public void visitTypeElement(PsiTypeElement typeElement) {
            super.visitTypeElement(typeElement);
            PsiType type = typeElement.getType();
            if (!(type instanceof PsiWildcardType)) {
                return;
            }
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            PsiType extendsBound = wildcardType.getExtendsBound();
            if (!(extendsBound instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)extendsBound;
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return;
            }
            if (!aClass.hasModifierProperty("final")) {
                return;
            }
            this.registerError(typeElement.getFirstChild(), aClass, 2);
        }
    }

    private static class TypeParameterExtendsFinalClassFix
    extends InspectionGadgetsFix {
        private TypeParameterExtendsFinalClassFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("type.parameter.extends.final.class.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection$TypeParameterExtendsFinalClassFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(@NotNull Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection$TypeParameterExtendsFinalClassFix.doFix must not be null");
            }
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)parent;
                TypeParameterExtendsFinalClassFix.replaceTypeParemeterAndReferencesWithType(typeParameter);
            } else if (parent instanceof PsiTypeElement) {
                PsiTypeElement typeElement = (PsiTypeElement)parent;
                PsiElement lastChild = typeElement.getLastChild();
                if (lastChild == null) {
                    return;
                }
                typeElement.replace(lastChild);
            }
        }

        private static void replaceTypeParemeterAndReferencesWithType(PsiTypeParameter typeParameter) throws IncorrectOperationException {
            PsiReferenceList extendsList = typeParameter.getExtendsList();
            PsiClassType[] referenceElements = extendsList.getReferencedTypes();
            if (referenceElements.length < 1) {
                return;
            }
            PsiClass finalClass = referenceElements[0].resolve();
            if (finalClass == null) {
                return;
            }
            PsiManager manager = typeParameter.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiJavaCodeReferenceElement classReference = factory.createClassReferenceElement(finalClass);
            Query query = ReferencesSearch.search((PsiElement)typeParameter, (SearchScope)typeParameter.getUseScope());
            for (PsiReference reference : query) {
                PsiElement referenceElement = reference.getElement();
                referenceElement.replace((PsiElement)classReference);
            }
            typeParameter.delete();
        }
    }
}

