/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.global;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.psiutils.MethodInheritanceUtils;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MethodReturnAlwaysConstantInspection
extends BaseGlobalInspection {
    private static final Key<Boolean> ALWAYS_CONSTANT = Key.create((String)"ALWAYS_CONSTANT");

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CLASSLAYOUT_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/global/MethodReturnAlwaysConstantInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    public CommonProblemDescriptor[] checkElement(RefEntity refEntity, AnalysisScope scope, InspectionManager manager, GlobalInspectionContext globalContext) {
        if (!(refEntity instanceof RefMethod)) {
            return null;
        }
        RefMethod refMethod = (RefMethod)refEntity;
        Boolean alreadyProcessed = (Boolean)refMethod.getUserData(ALWAYS_CONSTANT);
        if (alreadyProcessed != null && alreadyProcessed.booleanValue()) {
            return null;
        }
        if (!(refMethod.getElement() instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)refMethod.getElement();
        if (method.getBody() == null) {
            return null;
        }
        if (!MethodReturnAlwaysConstantInspection.alwaysReturnsConstant(method)) {
            return null;
        }
        Set<RefMethod> siblingMethods = MethodInheritanceUtils.calculateSiblingMethods(refMethod);
        for (RefMethod siblingMethod : siblingMethods) {
            PsiMethod siblingPsiMethod = (PsiMethod)siblingMethod.getElement();
            if (method.getBody() == null || MethodReturnAlwaysConstantInspection.alwaysReturnsConstant(siblingPsiMethod)) continue;
            return null;
        }
        ArrayList<ProblemDescriptor> out = new ArrayList<ProblemDescriptor>();
        for (RefMethod siblingRefMethod : siblingMethods) {
            PsiMethod siblingMethod = (PsiMethod)siblingRefMethod.getElement();
            PsiIdentifier identifier = siblingMethod.getNameIdentifier();
            if (identifier == null) continue;
            out.add(manager.createProblemDescriptor((PsiElement)identifier, InspectionGadgetsBundle.message("method.return.always.constant.problem.descriptor", new Object[0]), false, (LocalQuickFix[])null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
            siblingRefMethod.putUserData(ALWAYS_CONSTANT, (Object)true);
        }
        return (CommonProblemDescriptor[])out.toArray(new ProblemDescriptor[out.size()]);
    }

    private static boolean alwaysReturnsConstant(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length != 1) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (!(statement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
        PsiExpression value = returnStatement.getReturnValue();
        return value != null && PsiUtil.isConstantExpression((PsiExpression)value);
    }
}

