/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class IntroduceConstantFix
extends InspectionGadgetsFix {
    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("introduce.constant.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/fixes/IntroduceConstantFix.getName must not return null");
        }
        return string;
    }

    @Override
    public void doFix(final @NotNull Project project, ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/fixes/IntroduceConstantFix.doFix must not be null");
        }
        final PsiElement constant = descriptor.getPsiElement();
        Application application = ApplicationManager.getApplication();
        application.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
                RefactoringActionHandler introduceHandler = factory.createIntroduceConstantHandler();
                DataManager dataManager = DataManager.getInstance();
                DataContext dataContext = dataManager.getDataContext();
                introduceHandler.invoke(project, new PsiElement[]{constant}, dataContext);
            }
        });
    }
}

