/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ErrorRethrownInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ErrorNotRethrown" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/ErrorRethrownInspection.getID must not return null");
        }
        return "ErrorNotRethrown";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("error.rethrown.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/ErrorRethrownInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("error.rethrown.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/ErrorRethrownInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ErrorRethrownVisitor();
    }

    private static class ErrorRethrownVisitor
    extends BaseInspectionVisitor {
        private ErrorRethrownVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiCatchSection[] catchSections;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/errorhandling/ErrorRethrownInspection$ErrorRethrownVisitor.visitTryStatement must not be null");
            }
            super.visitTryStatement(statement);
            for (PsiCatchSection catchSection : catchSections = statement.getCatchSections()) {
                PsiParameter parameter = catchSection.getParameter();
                PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                if (parameter == null || catchBlock == null) continue;
                this.checkCatchBlock(parameter, catchBlock);
            }
        }

        private void checkCatchBlock(PsiParameter parameter, PsiCodeBlock catchBlock) {
            PsiType type = parameter.getType();
            PsiClass aClass = PsiUtil.resolveClassInType((PsiType)type);
            if (aClass == null) {
                return;
            }
            if (!ClassUtils.isSubclass(aClass, "java.lang.Error")) {
                return;
            }
            if (TypeUtils.typeEquals("java.lang.ThreadDeath", type)) {
                return;
            }
            PsiTypeElement typeElement = parameter.getTypeElement();
            PsiStatement[] statements = catchBlock.getStatements();
            if (statements.length == 0) {
                this.registerError((PsiElement)typeElement, new Object[0]);
                return;
            }
            PsiStatement lastStatement = statements[statements.length - 1];
            if (!(lastStatement instanceof PsiThrowStatement)) {
                this.registerError((PsiElement)typeElement, new Object[0]);
                return;
            }
            PsiThrowStatement throwStatement = (PsiThrowStatement)lastStatement;
            PsiExpression exception = throwStatement.getException();
            if (!(exception instanceof PsiReferenceExpression)) {
                this.registerError((PsiElement)typeElement, new Object[0]);
                return;
            }
            PsiElement element = ((PsiReference)exception).resolve();
            if (parameter.equals(element)) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }
    }
}

