/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.VariableSearchUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaughtExceptionImmediatelyRethrownInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("caught.exception.immediately.rethrown.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/CaughtExceptionImmediatelyRethrownInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("caught.exception.immediately.rethrown.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/CaughtExceptionImmediatelyRethrownInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiTryStatement tryStatement = (PsiTryStatement)infos[0];
        boolean removeTryCatch = tryStatement.getCatchSections().length == 1 && tryStatement.getFinallyBlock() == null;
        return new DeleteCatchSectionFix(removeTryCatch);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CaughtExceptionImmediatelyRethrownVisitor();
    }

    private static class CaughtExceptionImmediatelyRethrownVisitor
    extends BaseInspectionVisitor {
        private CaughtExceptionImmediatelyRethrownVisitor() {
        }

        public void visitThrowStatement(PsiThrowStatement statement) {
            super.visitThrowStatement(statement);
            PsiExpression expression = statement.getException();
            if (!(expression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiStatement previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
            if (previousStatement != null) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiStatement) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter = (PsiParameter)target;
            PsiElement declarationScope = parameter.getDeclarationScope();
            if (!(declarationScope instanceof PsiCatchSection)) {
                return;
            }
            PsiCatchSection catchSection = (PsiCatchSection)declarationScope;
            PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiCodeBlock.class);
            if (block == null) {
                return;
            }
            PsiElement blockParent = block.getParent();
            if (blockParent != catchSection) {
                return;
            }
            if (CaughtExceptionImmediatelyRethrownVisitor.isSuperClassExceptionCaughtLater((PsiVariable)parameter, catchSection)) {
                return;
            }
            Query query = ReferencesSearch.search((PsiElement)parameter);
            for (PsiReference reference : query) {
                PsiElement element = reference.getElement();
                if (element == expression) continue;
                return;
            }
            PsiTryStatement tryStatement = catchSection.getTryStatement();
            this.registerVariableError((PsiVariable)parameter, tryStatement);
        }

        private static boolean isSuperClassExceptionCaughtLater(PsiVariable parameter, PsiCatchSection catchSection) {
            PsiTryStatement tryStatement = catchSection.getTryStatement();
            PsiCatchSection[] catchSections = tryStatement.getCatchSections();
            for (int index = 0; catchSections[index] != catchSection && index < catchSections.length; ++index) {
            }
            PsiType type = parameter.getType();
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass parameterClass = classType.resolve();
            if (parameterClass == null) {
                return false;
            }
            for (int i = index; i < catchSections.length; ++i) {
                PsiClassType nextClassType;
                PsiClass aClass;
                PsiType nextType;
                PsiCatchSection nextCatchSection = catchSections[i];
                PsiParameter nextParameter = nextCatchSection.getParameter();
                if (nextParameter == null || !((nextType = nextParameter.getType()) instanceof PsiClassType) || (aClass = (nextClassType = (PsiClassType)nextType).resolve()) == null || !parameterClass.isInheritor(aClass, true)) continue;
                return true;
            }
            return false;
        }
    }

    private static class DeleteCatchSectionFix
    extends InspectionGadgetsFix {
        private final boolean removeTryCatch;

        DeleteCatchSectionFix(boolean removeTryCatch) {
            this.removeTryCatch = removeTryCatch;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String getName() {
            String string;
            if (this.removeTryCatch) {
                string = InspectionGadgetsBundle.message("remove.try.catch.quickfix", new Object[0]);
                if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/CaughtExceptionImmediatelyRethrownInspection$DeleteCatchSectionFix.getName must not return null");
                return string;
            }
            string = InspectionGadgetsBundle.message("delete.catch.section.quickfix", new Object[0]);
            if (string != null) return string;
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/CaughtExceptionImmediatelyRethrownInspection$DeleteCatchSectionFix.getName must not return null");
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            boolean removeTryCatch;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter = (PsiParameter)parent;
            PsiElement grandParent = parameter.getParent();
            if (!(grandParent instanceof PsiCatchSection)) {
                return;
            }
            PsiCatchSection catchSection = (PsiCatchSection)grandParent;
            PsiTryStatement tryStatement = catchSection.getTryStatement();
            boolean bl = removeTryCatch = tryStatement.getCatchSections().length == 1 && tryStatement.getFinallyBlock() == null;
            if (removeTryCatch) {
                boolean keepBlock;
                PsiElement containingElement;
                PsiCodeBlock codeBlock = tryStatement.getTryBlock();
                if (codeBlock == null) {
                    return;
                }
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 0) {
                    tryStatement.delete();
                }
                if ((containingElement = tryStatement.getParent()) instanceof PsiCodeBlock) {
                    PsiCodeBlock parentBlock = (PsiCodeBlock)containingElement;
                    keepBlock = VariableSearchUtils.containsConflictingDeclarations(codeBlock, parentBlock);
                } else {
                    keepBlock = true;
                }
                if (keepBlock) {
                    JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                    PsiElementFactory factory = psiFacade.getElementFactory();
                    PsiBlockStatement resultStatement = (PsiBlockStatement)factory.createStatementFromText("{}", element);
                    PsiCodeBlock resultBlock = resultStatement.getCodeBlock();
                    for (PsiStatement statement : statements) {
                        resultBlock.add((PsiElement)statement);
                    }
                    tryStatement.replace((PsiElement)resultStatement);
                } else {
                    for (PsiStatement statement : statements) {
                        containingElement.addBefore((PsiElement)statement, (PsiElement)tryStatement);
                    }
                    tryStatement.delete();
                }
            } else {
                catchSection.delete();
            }
        }
    }
}

