/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.ui.AddAction;
import com.siyeh.ig.ui.IGTable;
import com.siyeh.ig.ui.ListWrappingTableModel;
import com.siyeh.ig.ui.RemoveAction;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class BadExceptionCaughtInspection
extends BaseInspection {
    public String exceptionsString = "java.lang.NullPointerException,java.lang.IllegalMonitorStateException,java.lang.ArrayIndexOutOfBoundsException";
    final List<String> exceptionList = new ArrayList<String>(32);

    public BadExceptionCaughtInspection() {
        BadExceptionCaughtInspection.parseString(this.exceptionsString, this.exceptionList);
    }

    @NotNull
    public String getID() {
        if ("ProhibitedExceptionCaught" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/BadExceptionCaughtInspection.getID must not return null");
        }
        return "ProhibitedExceptionCaught";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("bad.exception.caught.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/BadExceptionCaughtInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("bad.exception.caught.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/BadExceptionCaughtInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        Form form = new Form();
        return form.getContentPanel();
    }

    public void readSettings(Element element) throws InvalidDataException {
        super.readSettings(element);
        BadExceptionCaughtInspection.parseString(this.exceptionsString, this.exceptionList);
    }

    public void writeSettings(Element element) throws WriteExternalException {
        this.exceptionsString = BadExceptionCaughtInspection.formatString(this.exceptionList);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BadExceptionCaughtVisitor();
    }

    private class Form {
        JPanel contentPanel;
        JButton addButton;
        JButton removeButton;
        IGTable table;

        Form() {
            this.$$$setupUI$$$();
            this.removeButton.setAction(new RemoveAction(this.table));
            this.addButton.setAction(new AddAction(this.table));
        }

        private void createUIComponents() {
            this.table = new IGTable(new ListWrappingTableModel(BadExceptionCaughtInspection.this.exceptionList, InspectionGadgetsBundle.message("exception.class.column.name", new Object[0])));
        }

        public JComponent getContentPanel() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JButton jButton;
            JButton jButton2;
            JPanel jPanel;
            this.createUIComponents();
            this.contentPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), 4, 4, false, false));
            JScrollPane jScrollPane = new JScrollPane();
            jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 3, 1, 0, 3, 7, 3, null, null, null));
            IGTable iGTable = this.table;
            jScrollPane.setViewportView((Component)((Object)iGTable));
            this.removeButton = jButton2 = new JButton();
            jButton2.setMargin(new Insets(3, 8, 3, 8));
            jPanel.add((Component)jButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 0, null, null, null));
            this.addButton = jButton = new JButton();
            jButton.setMargin(new Insets(3, 8, 3, 8));
            jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.contentPanel;
        }
    }

    private class BadExceptionCaughtVisitor
    extends BaseInspectionVisitor {
        private final Set<String> exceptionSet;

        private BadExceptionCaughtVisitor() {
            this.exceptionSet = new HashSet<String>(BadExceptionCaughtInspection.this.exceptionList);
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiParameter[] catchBlockParameters;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/errorhandling/BadExceptionCaughtInspection$BadExceptionCaughtVisitor.visitTryStatement must not be null");
            }
            super.visitTryStatement(statement);
            for (PsiParameter parameter : catchBlockParameters = statement.getCatchBlockParameters()) {
                PsiType type;
                String text;
                if (parameter == null || (text = (type = parameter.getType()).getCanonicalText()) == null || !this.exceptionSet.contains(text)) continue;
                PsiTypeElement typeElement = parameter.getTypeElement();
                this.registerError((PsiElement)typeElement, new Object[0]);
            }
        }
    }
}

