/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfusingElseInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ConfusingElseBranch" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/ConfusingElseInspection.getID must not return null");
        }
        return "ConfusingElseBranch";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("confusing.else.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/ConfusingElseInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("confusing.else.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/ConfusingElseInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingElseVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConfusingElseFix();
    }

    private static class ConfusingElseVisitor
    extends BaseInspectionVisitor {
        private ConfusingElseVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/ConfusingElseInspection$ConfusingElseVisitor.visitIfStatement must not be null");
            }
            super.visitIfStatement(statement);
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiStatement elseBranch = statement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            if (elseBranch instanceof PsiIfStatement) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                return;
            }
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
            if (nextStatement == null) {
                return;
            }
            if (!ControlFlowUtils.statementMayCompleteNormally(elseBranch)) {
                return;
            }
            PsiKeyword elseToken = statement.getElseElement();
            if (elseToken == null) {
                return;
            }
            this.registerError((PsiElement)elseToken, new Object[0]);
        }
    }

    private static class ConfusingElseFix
    extends InspectionGadgetsFix {
        private ConfusingElseFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("confusing.else.unwrap.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/ConfusingElseInspection$ConfusingElseFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement ifKeyword = descriptor.getPsiElement();
            PsiIfStatement ifStatement = (PsiIfStatement)ifKeyword.getParent();
            assert (ifStatement != null);
            PsiExpression condition = ifStatement.getCondition();
            String conditionText = condition == null ? "" : condition.getText();
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            String text = "if(" + conditionText + ')' + thenBranch.getText();
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            if (elseBranch instanceof PsiBlockStatement) {
                PsiBlockStatement elseBlock = (PsiBlockStatement)elseBranch;
                PsiCodeBlock block = elseBlock.getCodeBlock();
                PsiElement[] children = block.getChildren();
                if (children.length > 2) {
                    PsiElement containingElement = ifStatement.getParent();
                    assert (containingElement != null);
                    containingElement.addRangeAfter(children[1], children[children.length - 2], (PsiElement)ifStatement);
                }
            } else {
                PsiElement containingElement = ifStatement.getParent();
                assert (containingElement != null);
                containingElement.addAfter((PsiElement)elseBranch, (PsiElement)ifStatement);
            }
            ConfusingElseFix.replaceStatement((PsiStatement)ifStatement, text);
        }
    }
}

