/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;

public class ConditionalUtils {
    private ConditionalUtils() {
    }

    public static boolean isReturn(PsiStatement statement, String value) {
        if (statement == null) {
            return false;
        }
        if (!(statement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
        PsiExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null) {
            return false;
        }
        String returnValueText = returnValue.getText();
        return value.equals(returnValueText);
    }

    public static boolean isAssignment(PsiStatement statement, String value) {
        if (statement == null) {
            return false;
        }
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression = expressionStatement.getExpression();
        if (!(expression instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
        PsiExpression rhs = assignment.getRExpression();
        if (rhs == null) {
            return false;
        }
        String rhsText = rhs.getText();
        return value.equals(rhsText);
    }
}

